<?php
/**
 * Created by PhpStorm.
 * User: steven
 * Date: 7/31/19
 * Time: 5:57 PM
 */

namespace Hilco\GuzzleWrappers\RequestBuilders;


use Hilco\GuzzleWrappers\APIGuzzleWrapper;
use HilcoB2B\M3Request;

class TaxRequestBuilder extends RequestBuilder
{


    public function requestTaxes(){
        $request = $this->buildQueryArray();
        $this->buildAcceptableJson($request);

        $apiGuzzleWrapper = new APIGuzzleWrapper();
        $response = $apiGuzzleWrapper->get('v4/getTaxes', $request)->getBody()->getContents();
        $response = json_decode($response, true);
        return $response['details']['tax'];

    }

    public function buildRequest(){
        array_set($this->attributes, 'query.environment', array_has($this->attributes, 'query.environment') ? array_get($this->attributes, 'query.environment') : env('APP_ENV'));
        array_set($this->attributes, 'query.requestFrom', array_has($this->attributes, 'query.requestFrom') ? array_get($this->attributes, 'query.requestFrom') : 'b2b');

        return http_build_query($this->attributes);
    }

}