<?php
/**
 * Created by PhpStorm.
 * User: steven
 * Date: 10/23/19
 * Time: 11:36 AM
 */

namespace Hilco\Models;
use Log;



/**
 * Class BODImportLog
 * @package Hilco\Models
 * @property  string $bod_id
 * @property string $party_id
 * @property  string $result
 * @property string $bod_type
 * @property string $action_expression
 * @property string $bod
 * @property string $exception
 * @property string $misc
 * @property datetime $import_time
 * @property int $import_time_int : Import time converted to an indexable int.
 * @property  string $table
 * @property bigint $C_ID
 * @property
 * @
 *
 */

use Illuminate\Support\Facades\DB;

class BODImportLog extends WebModel
{
    protected $table = "BODImportLogs";
    protected $fillable = [
        "bod_id",
        "party_id",
        "result",
        "bod_type",
        "action_expression",
        "bod",
        "exception",
        "misc",
        "import_time",
        "import_time_int",
        "C_ID",
        "reimport",
    ];


    public static function createBODImportLog($BODImportLogAttributes){
        $BODImportLog = new BODImportLog();
        $BODImportLog->bod_id = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'bod_id');
        $BODImportLog->party_id = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'party_id');
        $BODImportLog->result = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'result');
        $BODImportLog->bod_type = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'bod_type');
        $BODImportLog->action_expression = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'action_expression');
        $BODImportLog->bod = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'bod');
        $BODImportLog->exception = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'exception');
        $BODImportLog->misc = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'misc');
        $BODImportLog->import_time = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'import_time');
        $BODImportLog->import_time_int = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'import_time_int');
        $BODImportLog->C_ID = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'C_ID');
        if(isset($BODImportLogAttributes['reimport'])){
            $BODImportLog->reimport = \Illuminate\Support\Arr::get($BODImportLogAttributes, 'reimport');
        }
        $BODImportLog->save();

    }

    public static function getFromLogs ($BODType = null , $options) {
        if(isset($BODType) && isset($options['subDays'])){
            $batch = BODImportLog::where('bod_type', '=', $BODType);

            $subDays = $options['subDays'];
            $batch = $batch->whereRaw("import_time > DATE_SUB(NOW(), INTERVAL ? DAY)", [$subDays]);

            if (isset($options['partyID'])) {
                $batch = $batch->where('party_id', '=', $options['partyID']);
            } else if (isset($options['C_ID']) and $options['C_ID'] != 0 and $options['C_ID'] != -1) {
                $batch = $batch->where('C_ID', '=', $options['C_ID']);
            }

            if (isset($options['onlyResult'])) {
                $batch = $batch->where('result', '=', $options['onlyResult']);
            }

            if (isset($options['offset'])) {
                $batch = $batch->offset($options['offset']);
            }
            if (isset($options['limit'])) {
                $batch = $batch->limit($options['limit']);
            }
        } else {
            // Removed unnecessary rows....this appears to be a safety measure, if --fromLogs was used without providing
            // a bod type then just return nothing so that nothing gets processed..
            return [];
        }

        Log::info("RUNNING BOD IMPORT LOG QUERY: \n " . $batch->toSql());
        Log::info(var_export($batch->getBindings()));
        return $batch->get();
    }

    /**
     * @return string
     */
    public function getBod()
    {
        return $this->bod;
    }


}