<?php

namespace Hilco\Models;

class AdditionalTax extends UuidModel
{
    protected $table = 'AdditionalTaxes';

    public function customerSegments()
    {
        return $this->belongsToMany(CustomerSegment::class, "AdditionalTax_CustomerSegment", 'additionaltax_id', 'customersegment_id');
    }

	public function scopeInEffect($query) {
		return $query
			->where(function($query) {
				$query->where('effective_date', '=', '0000-00-00')
					->orWhere('effective_date', '<', date('Y-m-d'));
			})
			->where(function($query) {
				$query->where('expiration_date', '=', '0000-00-00')
					->orWhere('expiration_date', '>', date('Y-m-d'));
			});
	}
}
