@if($edit)
    @if($wrap) <div class="mceNonEditable component-container" data-component-key="bannerCarousel"> @endif
        <h4>Banner Carousel</h4>
        <p>Display banners across the entire width of the page that rotate.</p>
        <div data-banner-id="{{ $bannerId }}" class="banner-container">
            <div class="row slides-container">
                @foreach ($slides as $slideId => $slide)
                    <div data-slide-id="{{$slideId}}" data-url="{{ $slide['url'] }}" data-web-asset-id="{{ $slide['webAssetId'] }}" class="col-md-3 slide-container">
                        <div style="margin: 5px; border: 1px solid black;">
                            <img class="center-block img-responsive" src="{{ webAssetUrl($slide['webAssetId']) }}" alt="">
                            <br>
                            <div class="slide-url">{{ $slide['url'] }}</div>
                            <a class="edit-slide-button btn btn-primary" href="#">Edit Slide</a>
                            <a class="edit-slide-url-button btn btn-primary" href="#">Edit Url</a>
                            <a class="delete-slide-button btn btn-danger" href="#">Delete Slide</a>
                        </div>
                    </div>
                @endforeach
            </div>
            <a href="#" class="btn btn-primary add-slide-button">Add Slide</a>
        </div>
    @if($wrap) </div> @endif
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('bannerCarousel', {
            menuText: 'Banner Carousel',
            bladeTemplate: 'hilco::components.bannerCarousel',
            init: function (body) {
                $(body).on('click', 'a.add-slide-button', function() {
                    var banner = $(this).closest('.banner-container');
                    var lastSlide = $(banner).find('div.slide-container').last();
                    var newSlideId = lastSlide.data('slide-id') + 1;
                    var newSlide = lastSlide.clone().attr('data-slide-id', newSlideId);
                    newSlide.find('[data-slide-id]').each(function () {
                        $(this).attr('data-slide-id', newSlideId);
                    }).find('img').attr('src', '');
                    $(banner).find('.slides-container').append(newSlide);
                });
                $(body).on('click', 'a.delete-slide-button', function () {
                    var slide = $(this).closest('.slide-container');
                    var slideCount = $(this).closest('.banner-container').find('.slide-container').length;
                    if (slideCount == 1) {
                        alert('You cannot delete the last slide!');
                        return;
                    }

                    $(slide).remove();
                });
                $(body).on('click', 'a.edit-slide-button', function () {
                    var slide = $(this).closest('.slide-container');
                    assets.finder({
                        successFunction: function (data) {
                            $(slide).attr('data-web-asset-id', data.id).find('img').attr('src', data.url);
                        }
                    });
                });
                $(body).on('click', 'a.edit-slide-url-button', function () {
                    var slide = $(this).closest('.slide-container');
                    assets.link({
                        successFunction: function (url) {
                            $(slide).attr('data-url', url);
                            $(slide).find('.slide-url').text(url);
                        }
                    });
                });
            },
            serialize: function (componentNode) {
                var data = {
                    slides: [],
                };
                $(componentNode).find('.slide-container').each(function () {
                    data.slides.push({
                        webAssetId: $(this).data('web-asset-id'),
                        url: $(this).data('url'),
                    });
                });
                return data;
            },
        });
    </script>
@endif

@if($view)
    <div id="banner-carousel" class="owl-carousel">
        @foreach($slides as $slide)
            <div>
                @if(array_get($slide, 'url')) <a href="{{ $slide['url'] }}"> @endif
                    <img src="{{ webAssetUrl($slide['webAssetId']) }}" />
                @if(array_get($slide, 'url')) </a> @endif
            </div>
        @endforeach
    </div>
@endif
