@if($edit)
    <div class="mceNonEditable component-container" data-component-key="jotform">
<a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.jotform')</h4>
        <p>@lang('hilco::app.embeds_a_jotform_component_on_the_page')</p>
        @lang('hilco::app.source') <a href="#" class="jotform-source" data-source="@if(isset($source)) {{$source}} @endif">@if(isset($source) && trim($source) != "") {{ $source }} @else None @endif</a><br>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('jotform', {
            menuText: '@lang('hilco::app.jotform')',
            bladeTemplate: 'hilco::components.jotform',
            init: function (body) {
                $(body).on('click', '.jotform-source', function () {
                    var button = $(this);
                    var htmlEditor = new $.fn.dataTable.Editor({
                        title: '@lang('hilco::app.source')',
                        fields: [
                            {
                                label: '@lang('hilco::app.source')',
                                name: 'source',
                                type: 'text',
                                def: $(button).attr('data-source'),
                            },
                        ]
                    }).title('@lang('hilco::app.source')').buttons({
                        label: "@lang('hilco::app.save')",
                        fn: function () {
                            this.submit(null, null, function (data) {
                                $(button).attr('data-source', data.data.key.source);
                                $(button).text(data.data.key.source);
                            });
                        }
                    });
                    htmlEditor.edit('key');
                });
            },
            serialize: function (componentNode) {
                return {
                    source: componentNode.find('.jotform-source').data('source'),
                };
            },
        });
    </script>
@endif

@if($view)
    <script type="text/javascript" src="@if(isset($source)){{$source}}@endif"></script>
@endif
