<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WebPermission extends WebModel {

	protected $table = 'WebPermissions';
	protected $fillable = ['name', 'slug', 'description', 'is_enabled'];

	public function webUsers()
	{
		return $this->belongsToMany(WebUser::class, 'WebPermission_WebUser');
	}

	public function webRoles()
	{
		return $this->belongsToMany(WebRole::class, 'WebPermission_WebRole', 'webpermission_id', 'webrole_id');
	}
}