<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 10/4/2016
 * Time: 3:53 PM
 */

namespace Hilco\Models;


use Illuminate\Database\Eloquent\Builder;

class WebUrl extends WebModel {
    protected $table = 'WebUrls';
    protected $fillable = ['websilo_id'];

    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function scopeCurrent(Builder $query) {
        $url = \Illuminate\Support\Arr::get($_SERVER, 'HTTP_HOST', 'CLI');
        if ($url) $query->where('url', $url);
        return $query->take(1);
    }
}