@if($edit)
    <div class="mceNonEditable component-container componentLayout" data-component-key="componentLayout">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.componentLayout')</h4>
        <div class="view-full-container">
            @include('hilco::components.targetCustomer.viewSelector', ['alternateViews' => $alternateViews ?? []])
            @include('hilco::components.componentLayoutView',
            [
                'viewId' => 0,
                'tiles' => $tiles,
                'selectedLayout' => $selectedLayout,
                'displayName' => $displayName,
                'defaultVisibility' => $defaultVisibility ?? 'Visible',
                'visibleDates' => $visibleDates ?? [],
                'visibleDatesFormatted' => $visibleDatesFormatted ?? 'All',
                'default' => true
            ])
            @foreach($alternateViews ?? [] as $altViewId => $altView)
                @include('hilco::components.componentLayoutView',
                [
                'viewId' => $altViewId,
                    'tiles' => Arr::get($altView, 'tiles', []),
                    'selectedLayout' => Arr::get($altView, 'selectedLayout', ''),
                    'displayName' => Arr::get($altView, 'displayName', ''),
                    'targetCustomers' => Arr::get($altView, 'targetCustomers', []),
                    'targetCustomersFormatted' => Arr::get($altView, 'targetCustomersFormatted', 'None'),
                    'visibleDates' => Arr::get($altView, 'visibleDates', []),
                    'visibleDatesFormatted' => Arr::get($altView, 'visibleDatesFormatted', 'All'),
                    'default' => false
                ])
            @endforeach
        </div>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('componentLayout', {
            menuText: '@lang('hilco::app.componentLayout')',
            bladeTemplate: 'hilco::components.componentLayout',
            init: function (body) {
                var layouts = {
                    full:{
                        display_name : '100%',
                        total_tiles : 1,
                        tile_size_values :[12]
                    },
                    halves:{
                        display_name : '50% | 50%',
                        total_tiles : 2,
                        tile_size_values :[6, 6]
                    },
                    thirds: {
                        display_name : '33% | 33% | 33%',
                        total_tiles : 3,
                        tile_size_values: [4, 4, 4]
                    },
                    oneAndTwo: {
                        display_name : '33% | 66%',
                        total_tiles : 2,
                        tile_size_values: [4, 8]
                    },
                    twoAndOne: {
                        display_name : '66% | 33%',
                        total_tiles : 2,
                        tile_size_values: [8, 4]
                    }
                };
                function buildMenu() {
                    var menu = {};
                    $.each(_visionwareComponents, function (key, component) {
                        if(component.bladeTemplate !== 'hilco::components.componentLayout')
                            menu[component.bladeTemplate] = component.menuText;
                    });
                    return menu;
                }

                $(body).on('click', '#changeLayout2', function () {
                    var mainComponent = $(this).closest('.component-view-container');

                    var message = "Choose a layout for the content.";
                    var layout = $(mainComponent).find('h4.current-component-layout').attr('data-current-layout');
                    if(layout == null) layout = "";

                    swal({
                        title: "Change Layout",
                        type: "info",
                        html: message,
                        input: 'select',
                        inputOptions: {
                            full: '100%',
                            halves: '50% | 50%',
                            thirds:'33% | 33% | 33%',
                            oneAndTwo: '33% | 66%',
                            twoAndOne:'66% | 33%'
                        },
                        inputPlaceholder: 'Select a layout',
                        inputValue: layout,
                        confirmButtonClass: "btn-primary",
                        showCancelButton: true,
                        allowOutsideClick: false,
                    }).then(
                        function(inputValue){
                            var current_layout = layouts[layout];
                            var chosen_layout = layouts[inputValue];
                            if(current_layout != chosen_layout){

                                $(mainComponent).find('h4.current-component-layout').attr('data-current-layout', inputValue);
                                $(mainComponent).find('h4.current-component-layout').attr('data-display-name', layouts[inputValue]['display_name']);
                                $(mainComponent).find('h4.current-component-layout').html('Current Layout: '+ layouts[inputValue]['display_name']);

                                //change the tiles and assign the size
                                if(current_layout['total_tiles'] > chosen_layout['total_tiles']){
                                    var tilesToRemove = current_layout['total_tiles'] - chosen_layout['total_tiles'];
                                    for (let step = 0; step < tilesToRemove; step++) {
                                        var lastTile = $(mainComponent).find('div.component-tile-container').last();
                                        $(lastTile).remove();
                                    }
                                }else if(current_layout['total_tiles'] < chosen_layout['total_tiles']){
                                    var tilesToAdd = chosen_layout['total_tiles'] - current_layout['total_tiles'];
                                    for (let step = 0; step < tilesToAdd; step++) {
                                        var lastTile = $(mainComponent).find('div.component-tile-container').last();
                                        var newTileId = lastTile.data('tile-id') + 1;
                                        var newTile = lastTile.clone().attr('data-tile-id', newTileId);
                                        newTile.find('.component-area').attr('id', 'component-area-'+newTileId);
                                        newTile.find('.component-area').html('');
                                        newTile.find('.select-component-button').attr('data-linked-component', '#component-area-'+newTileId);
                                        $(mainComponent).find('.component-tiles-container').append(newTile);
                                    }
                                }

                                var loops = 0;

                                $(mainComponent).find('.component-tile-container').each(function () {

                                    var tileSize = chosen_layout['tile_size_values'][loops];
                                    $(this).attr('data-tile-size', tileSize);
                                    loops++;
                                });
                            }
                        });
                }).on('click', '.select-component-button', function () {
                    var mainComponent = $(this).closest('.component-view-container');
                    var linkedComponent = $(this).data('linked-component');
                    var componentTile = $(mainComponent).find(linkedComponent);

                    var message = "Choose a component for the layout.";
                    var component = $(this).attr('data-current-component');
                    if(component == null) component = "";

                    swal({
                        title: "Select a Component",
                        type: "info",
                        html: message,
                        input: 'select',
                        inputOptions: buildMenu(),
                        inputPlaceholder: 'Select a Component',
                        inputValue: component,
                        confirmButtonClass: "btn-primary",
                        showCancelButton: true,
                        allowOutsideClick: false,
                    }).then(
                        function(inputValue){
                            $.ajax({
                                url: '{{ route('landing.component') }}',
                                type: 'GET',
                                data: {
                                    _token: _csrf_token,
                                    component: inputValue,
                                },
                                success: function (data) {
                                    $(componentTile).html(data);
                                },error: function (jqXHR, exception){

                                }
                            })
                        });
                });
            },
            serialize: function (componentNode) {
                var viewDiv = $(componentNode).find('div.view-container.default');
                var alternateViews = {};
                viewDiv.closest('.view-full-container').find('.view-container.alternate').each(function () {
                    var componentHeader = $(this).find('h4.current-component-layout');
                    var selectedLayout = componentHeader.attr('data-current-layout');
                    var displayName = componentHeader.attr('data-display-name');
                    var targetCustomers = {};
                    try{
                        targetCustomers = JSON.parse($(this).attr('data-target-customers'));
                    }catch (e){
                        //use the empty object
                    }
                    var visibleDates = {};
                    try{
                        visibleDates = JSON.parse($(this).attr('data-visible-dates'));
                    }catch (e){
                        //use the empty object
                    }

                    var altViewData = {
                        selectedLayout: selectedLayout,
                        displayName: displayName,
                        targetCustomers: targetCustomers,
                        targetCustomersFormatted: $(this).find('.view-targetcustomers').text(),
                        visibleDates: visibleDates,
                        visibleDatesFormatted: $(this).find('.view-visibledates').text(),
                        tiles: {},
                    };

                    $(this).find('.component-tile-container').each(function () {
                        var tileId = $(this).data('tile-id');
                        var component = $(this).find('[data-component-key]');
                        var key = component.data('component-key');
                        if(key != null){
                            var componentData = _visionwareComponents[key].serialize(component);
                            var bladeTemplate = _visionwareComponents[key].bladeTemplate;
                            componentData['isInLayout'] = true;
                        }else{
                            var componentData = null;
                            var bladeTemplate = null;
                        }

                        altViewData.tiles[tileId] = {
                            tileSize: $(this).data('tile-size'),
                            component: bladeTemplate,
                            data: componentData
                        };
                    });
                    alternateViews[$(this).attr('data-view-id')] = altViewData;
                });

                var selectedLayout = viewDiv.find('h4.current-component-layout').data('current-layout');
                var displayName = viewDiv.find('h4.current-component-layout').data('display-name');
                var visibleDates = {};
                try{
                    visibleDates = JSON.parse(viewDiv.attr('data-visible-dates'));
                }catch (e){
                    //use the empty object
                }

                var data = {
                    selectedLayout: selectedLayout,
                    displayName: displayName,
                    tiles: {},
                    defaultVisibility: viewDiv.attr('data-default-visibility').trim(),
                    visibleDates: visibleDates,
                    visibleDatesFormatted: viewDiv.find('.view-visibledates').text(),
                    alternateViews: alternateViews
                };
                viewDiv.find('.component-tile-container').each(function () {
                    var tileId = $(this).data('tile-id');
                    var component = $(this).find('[data-component-key]');
                    var key = component.data('component-key');
                    if(key != null){
                        var componentData = _visionwareComponents[key].serialize(component);
                        var bladeTemplate = _visionwareComponents[key].bladeTemplate;
                        componentData['isInLayout'] = true;
                    }else{
                        var componentData = null;
                        var bladeTemplate = null;
                    }

                    data.tiles[tileId] = {
                        tileSize: $(this).data('tile-size'),
                        component: bladeTemplate,
                        data: componentData
                    };

                });
                return data;
            },
        });
    </script>
@endif

@if($view)
    @include('hilco::components.targetCustomer.viewRenderer',
['blade' => 'hilco::components.componentLayout',
'bladeViewArgs' =>
    ['tiles' => $tiles,
    'selectedLayout' => $selectedLayout,
    'displayName' => $displayName,
    'defaultVisibility' => $defaultVisibility ?? 'Visible',
    'alternateViews' => $alternateViews?? []],
'mode' => 'view'])

@endif
