<?php

namespace Hilco\Models;

use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use Venturecraft\Revisionable\RevisionableTrait;

class WebGroup extends WebModel implements HasLandingPageInterface {
	protected $table = "WebGroups";
	protected $fillable = ['name', 'slug', 'webSiloIds' ,'is_visible', 'detail'];
	protected $context_attributes = [];
	protected $context_table = 'WebContext_WebGroup';
	protected $context_foreign_key = 'webgroup_id';
	protected $casts = [
	    'is_visible' => 'boolean',
        'layout' => 'array',
	];

    protected $hierarchyParent = false;

	public function webSilos() {
		return $this->belongsToMany(WebSilo::class, 'WebGroup_WebSilo', 'webgroup_id', 'websilo_id')->withPivot('display_order');
	}

	public function webCategories() {
		return $this->belongsToMany(WebCategory::class, 'WebCategory_WebGroup', 'webgroup_id', 'webcategory_id')->withPivot('display_order');
	}

    public function visibleWebCategories() {
        return $this->belongsToMany(WebCategory::class, 'WebCategory_WebGroup', 'webgroup_id', 'webcategory_id')
            ->withPivot('display_order')
            ->visible()
            ->displayOrder()
        ;
    }

    public function scopeDisplayOrder(Builder $query) {
        return $query->orderBy('pivot_display_order', 'asc')->orderBy('name', 'asc');
    }

    public function scopeAlphabetical(Builder $query) {
        return $query->orderBy('name', 'asc');
    }

	public function webCategoriesOrdered() {
        return $this->webCategories()->orderBy('pivot_display_order')->orderBy('name')
            ;
    }

	public function webLandingPages() {
		return $this->belongsToMany(WebLandingPage::class, 'WebGroup_WebLandingPage', 'webgroup_id', 'weblandingpage_id');
	}

	public function featuredChildren() {
	    return $this->webCategories()->wherePivot('is_featured', 1);
    }

	public function getAssetPrefix() {
		return "webGroups/{$this->id}/webContexts";
	}

	public function setWebSiloIdsAttribute($ids) {
		$this->save();
		$this->webSilos()->sync($ids);
	}

	public function scopeVisible(Builder $query) {
//	    $webSiloId = WebSilo::current()->id;
		return $query
//            ->whereHas('webSilos', function ($query) use ($webSiloId) {
//                return $query->visible()->where('WebGroup_WebSilo.websilo_id', '=', $webSiloId);
//            })
			->where('WebGroups.is_visible', '1')
		;
	}

//	public function scopeForMenu(Builder $query) {
//        $query->visible()
//            ->join('WebCategory_WebGroup as WCWG', 'WCWG.webgroup_id', '=', 'WebGroups.id')
//            ->join('WebCollection_WebCategory as WLWC', 'WLWC.webcategory_id', '=', 'WCWG.webcategory_id')
//            ->join('WebCategories', 'WebCategories.id', '=', 'WCWG.webcategory_id')
//            ->join('WebCollections', 'WebCollections.id', '=', 'WLWC.webcollection_id')
//            ->orderBy('WCWG.display_order', 'asc')
//            ->orderBy('WebCategories.name', 'asc')
//            ->orderBy('WLWC.display_order', 'asc')
//            ->orderBy('WebCollections.name', 'asc')
//            ->select(DB::raw('WebGroups.*'))
//            ->groupBy('WebGroups.id')
//        ;
//        return $query;
//    }

    public function slugUrl() {
        return route('group.slug', [$this->slug]);
    }

    public function getParentRelationName() {
        return false;
    }

    use HasSlug, HasLandingPage, RevisionableTrait;
}
