<?php

namespace Hilco\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use Venturecraft\Revisionable\RevisionableTrait;

/**
 * Class WebCategory
 * @package Hilco\Models
 * @method static WebCategory firstOrNew(array $attributes)
 */
class WebCategory extends WebModel implements HasLandingPageInterface {
    protected $table = "WebCategories";
    protected $fillable = ['name', 'slug', 'webGroupIds', 'is_visible', 'detail', 'sort_priority'];
    protected $casts = [
        ['is_visible' => 'boolean']
    ];
    protected $hierarchyParent = WebGroup::class;

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function webGroups() {
        return $this->belongsToMany(WebGroup::class, 'WebCategory_WebGroup', 'webcategory_id', 'webgroup_id')->withPivot('display_order');
    }

    public function webCollections() {
        return $this->belongsToMany(WebCollection::class, 'WebCollection_WebCategory', 'webcategory_id', 'webcollection_id')->withPivot('display_order');
    }

    public function visibleWebCollections() {
        return $this->belongsToMany(WebCollection::class, 'WebCollection_WebCategory', 'webcategory_id', 'webcollection_id')
            ->withPivot('display_order')
            ->visible()
            ->displayOrder()
        ;
    }

    public function scopeDisplayOrder(Builder $query) {
        return $query->orderBy('pivot_display_order', 'asc')->orderBy('name', 'asc');
    }

    public function scopeAlphabetical(Builder $query) {
        return $query->orderBy('name', 'asc');
    }

    public function featuredChildren() {
        return $this->webCollections()->wherePivot('is_featured', 1);
    }

    public function scopeInGroup($query, $groupId) {
        return $query->whereHas('webGroups', function ($query) use ($groupId) {
            $query->where('webgroup_id', $groupId);
        });
    }

    public function setWebGroupIdsAttribute($ids) {
        $this->save();
        $this->webGroups()->sync($ids);
    }

//    public function scopeHavingFamily($query, $webFamilyId) {
//        return $query->whereHas('webFamilies', function ($query) use ($webFamilyId) {
//            $query->where('webfamily_id', $webFamilyId);
//        });
//    }

//    public function familiesFeaturedInContext($contextId, $isFeatured = true) {
//        return $this->webFamilies()->whereHas('contexts', function ($query) use ($contextId, $isFeatured) {
//            return $query
//                ->where('webcontext_id', $contextId)
//                ->where('is_featured', $isFeatured)
//            ;
//        });
//    }


//    public function getFiltersArrayAttribute() {
//        $array = [];
//        $this
//            ->webAttributeFilters()
//            ->with('webAttribute', 'webAttributeFilterValues')
//            ->get()
//            ->each(function ($item) use (&$array) {
//                $array[$item->webattribute_id]['attribute_name'] = $item->webAttribute->attribute_name;
//                $array[$item->webattribute_id]['values'][$item->id] = $item->filter_display;
//            })
//        ;
//        return $array;
//    }
//
//    public function getWebLayoutAttribute() {
//        if (is_null($this->weblayout_id)) {
//            return $this->context->webLayout()->with('webLayoutComponents')->first();
//        } else {
//            return WebLayout::with('webLayoutComponents')->find($this->weblayout_id);
//        }
//    }
//
//    use SupportsDataTablesTrait;
//
//    public function createAttributeFilter($attributeId, $filterDisplay) {
//        $this->webAttributeFilters()->create(['webattribute_id' => $attributeId, 'filter_display' => $filterDisplay]);
//    }

    public function scopeVisible(Builder $query) {
        return $query
            ->where('WebCategories.is_visible', '1')
//            ->whereHas('webCollections', function ($query) {
//                return $query->visible();
//            })
        ;
    }

    public function slugUrl() {
        return route('category.slug', [$this->slug]);
    }

    use HasAssets, HasSlug, HasLandingPage, RevisionableTrait;

    public function getParentRelationName() {
        return 'webGroups';
    }
}
