<?php

namespace Hilco\Models;

use DateTime;

/**
 * @property string $file_name
 * @property DateTime $last_modified
 */
class InventoryFile extends WebModel {
    protected $table = "InventoryFiles";
    protected $fillable = ["file_name", "last_modified"];
    protected $casts = ["last_modified" => "datetime"];

    /**
     * @return string
     */
    public function getFileName(): string {
        return $this->file_name;
    }

    /**
     * @return DateTime
     */
    public function getLastModifiedDateTime(): DateTime {
        return $this->last_modified;
    }
}