@if($edit)
    @if($wrap) <div class="mceNonEditable component-container" data-component-key="bestSellers"> @endif
        <h4>Best Sellers</h4>
        <p>Displays best-selling families that are children of this container.</p>
    @if($wrap) </div> @endif
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('bestSellers', {
            menuText: 'Best Sellers',
            bladeTemplate: 'hilco::components.bestSellers',
            init: function (body) {

            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    @if(isset($bestSellers) && count($bestSellers))
        <div class="row container center-block">
            <div class="col-md-12">
                <div class="panel panel-danger">
                    <div class="panel-heading">
                        <h3 class="panel-title text-center">Best Sellers</h3>
                    </div>
                    <div class="panel-body" style="height: 280px">
                        <div id="best-sellers-carousel">
                            @foreach ($bestSellers as $family)
                                <div class="home-best-seller-item" style="display: none;">
                                    <div class="image">
                                        <img class="img-responsive" style="width: auto; max-height: 120px; margin: 0 auto;" src="{{ $family->primaryImage('medium') }}" alt="{{ $family->name }}">
                                    </div>
                                    <div class="caption">
                                        <a href="{{ route('family.slug', [$family->slug]) }}">
                            <span class="h4">
                                {{ $family->name }}
                            </span>
                                        </a>
                                    </div>
                                    @if($family->webParts->count() > 1)
                                        <a class="btn btn-sm btn-default" href="{{ route('family.slug', [$family->slug]) }}">See Product Options</a>
                                        <div class="price text-danger">
                                            ${{ number_format($family->price_range[0], 2) }} - ${{ number_format($family->price_range[1], 2) }}
                                        </div>
                                    @else
                                        <div class="price text-danger">
                                            ${{ number_format($family->price, 2) }}
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script type="text/javascript">
            $(document).ready(function() {
                var bestSellersCarousel = $('#best-sellers-carousel');
                bestSellersCarousel.on({
                    'initialized.owl.carousel': function() {
                        bestSellersCarousel.find('.home-best-seller-item').show();
                    }
                }).owlCarousel({
                    autoplay: true,
                    autoplayTimeout: 3000,
                    loop: true,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        320: {
                            items: 1
                        },
                        480: {
                            items: @if(auth()->user()) 1 @else 2 @endif,
                        },
                        768: {
                            items: @if(auth()->user()) 1 @else 3 @endif,
                        },
                        992: {
                            items: @if(auth()->user()) 2 @else 3 @endif,
                        },
                        1440: {
                            items: @if(auth()->user()) 2 @else 4 @endif,
                        },
                    },
                });
            });
        </script>
    @endif
@endif
