<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Relations\Relation;

/**
 * Hilco\Models\PromoRule
 *
 */
class PromoRule extends Model
{
	protected $table = 'PromoRules';
	protected $fillable = ['rule_object_type','rule_condition','rule_object_id'];

	public static $types = [
		'part-quantity'=>'Parts Quantity',
		'promo-code'=>'Promo Code',
		'customer'=>'For Customer',
	];

	protected static $morphMap = [
		'part-quantity' => WebPart::class,
		'promo-code' => PromoCode::class,
		'customer' => Customer::class,
	];

	protected static function boot()
	{
		parent::boot();
		Relation::morphMap(self::$morphMap);
	}


	public function rule_object()
	{
		return $this->morphTo();
	}

	public function promo(){
		return $this->belongsTo(Promo::class, 'promo_id', 'id');
	}
}
