<?php

namespace Hilco\Models;
use DB;

/**
 * Hilco\Models\OrderMainLine
 *
 * @property mixed $id
 * @property mixed $parent_id
 * @property string $parent_type
 * @property mixed $division_id
 * @property mixed $salesorder_id
 * @property mixed $line_number
 * @property mixed $line_status
 * @property mixed $plant_id
 * @property mixed $warehouse_id
 * @property mixed $binlocation_id
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine wherePlantId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereInvoiceNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereBilltoCustomersegmentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereSoldtoCustomersegmentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereFob($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine wherePaymentTerms($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereTaxAmt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereFreightAmt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereInvoiceDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereShipDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereCarrier($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereShipVia($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereCustomerPo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereShippingPolicy($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereDeletedAt($value)
 * @mixin \Eloquent
 * @property-read \Hilco\Models\OrderPartLine $partLines
 * @property-read \Hilco\Models\OrderMiscLine $miscLine
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\OrderSubLine[] $subLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\OrderSubLine[] $discSubLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\OrderSubLine[] $miscSubLines
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereParentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereParentType($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereSalesorderId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereLineNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereLineStatus($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereWarehouseId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereBinlocationId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereDateUploaded($value)
 * @property integer $line_order
 * @property string $line_suborder
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereLineOrder($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMainLine whereLineSuborder($value)
 * @property-read \Hilco\Models\OrderSubLine $attnSubLine
 * @property-read \Hilco\Models\OrderSubLine $instructionSubLine
 */
class OrderMainLine extends UuidModel
{
    protected $table = 'SalesOrderMainLines';
//
//    public function order()
//    {
//        return $this->belongsTo(Order::class);
//    }

    public function partLine() {
        return $this->hasOne(OrderPartLine::class, 'id', 'parent_id');
    }

    public function partLines() {
        return $this->hasOne(OrderPartLine::class, 'id', 'parent_id');
    }

    public function miscLine()
    {
        return $this->hasOne(OrderMiscLine::class, 'id', 'parent_id')->with('miscCharge');
    }

    public function subLines()
    {
        return $this->hasMany(OrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderDiscLines');
    }

    public function orderLineSchedules()
    {
        return $this->hasMany(SalesOrderLineSchedule::class, 'salesordermainline_id');
    }
    
    public function discSubLines()
    {
        return $this->hasMany(OrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderDiscLines')->whereNull('deleted_at')->with('discountLine');
    }

    public function miscSubLines()
    {
        return $this->hasMany(OrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderMiscLines')->whereNull('deleted_at')->with('miscLine.miscCharge');
    }
    
    public function attnSubLine() {
        return $this->hasOne(OrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderAttnLines')->with('attnLine');
    }

    public function instructionSubLine() {
        return $this->hasOne(OrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderInstructionLines')->with('instructionLine');
    }

    public function xrefSubLine() {
        return $this->hasOne(OrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderXrefLines')->with('xrefLine');
    }
    
    public function commentLine()
    {
        return $this->hasOne(OrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderCommentLines')->with('commentLine');
    }
    
    public function extractComments($subLine) {
        if (is_null($subLine)) return [];
        $commentLine = $subLine->commentLine;
        $comments = array();
        if ($commentLine->line_comment_all != null && $commentLine->line_comment_all != '') {
            $comments['A'] = $commentLine->line_comment_all;
        }
        if ($commentLine->line_comment_external != null && $commentLine->line_comment_external != '') {
            $comments['E'] = $commentLine->line_comment_external;
        }
        if ($commentLine->line_comment_internal != null && $commentLine->line_comment_internal != '') {
            $comments['I'] = $commentLine->line_comment_internal;
        }
        if ($commentLine->line_comment_display != null && $commentLine->line_comment_display!= '') {
            $comments['D'] = $commentLine->line_comment_display;
        }
        return $comments;
    }

    public function shipPlant() {
        return $this->belongsTo(Plant::class, 'plant_id');
    }

    public function shipWarehouse() {
        return $this->belongsTo(Warehouse::class, 'warehouse_id');
    }

    public function order() {
        return $this->belongsTo(Order::class, 'salesorder_id');
    }

    public function shipBinLocation() {
        return $this->belongsTo(BinLocation::class, 'binlocation_id');
    }


}
