<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;

/**
 * Hilco\Models\ProductCategories
 *
 * @property mixed $id
 * @property string $product_category
 * @property mixed $productcategorygroup_id
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Hilco\Models\ProductCategoryGroup $categoryGroup
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategory whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategory whereProductCategory($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategory whereProductcategorygroupId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategory whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategory whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategory whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @property-read \Hilco\Models\ProductCategoryGroup $group
 * @property-read \Hilco\Models\WebProductCategory $details
 * @property-read mixed $name
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategory whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategory inGroup($group)
 */
class ProductCategory extends Model
{
	protected $table = 'ProductCategories';

	public function group()
	{
		return $this->belongsTo(ProductCategoryGroup::class, 'productcategorygroup_id', 'id');
	}

    public function productCategoryGroup() {
        return $this->belongsTo(ProductCategoryGroup::class, 'productcategorygroup_id', 'id');
    }

	public function scopeInGroup($query, $group) {
		return $query->whereProductcategorygroupId($group);
	}

	public static function getProductFamilies($cat_id)
	{
		return ProductFamilies::where('productcategory_id', '=', $cat_id)->get(['id']);
	}

	public function details() {
		return $this->hasOne(WebCategory::class, 'productcategorygroup_id', 'id');
	}

	public function getNameAttribute() {
		return $this->product_category;
	}

	public function productFamilies() {
	    return $this->hasMany(ProductFamilies::class, 'productcategory_id', 'id');
    }
}
