<?php

namespace Hilco\Models;
use Eloquent;
use Hilco\SoftDeletes;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

/**
 * Hilco\Models\CustomerSegment
 *
 * @property-read integer $id
 * @property-read Division $division
 * @property-read integer $division_id
 * @property-read string $cust_no
 * @property-read integer $customer_id
 * @property-read string $cust_name
 * @property-read string $bill_cust_no
 * @property-read integer $billto_customer_id
 * @property-read string $bill_cust_name
 * @property-read string $parent_cust_no
 * @property-read integer $parent_customer_id
 * @property-read string $parent_cust_name
 * @property-read string $cust_type
 * @property-read mixed $customertypechannel_id
 * @property-read string $sales_rep
 * @property-read string $sales_group
 * @property-read string $sales_mgr
 * @property-read boolean $active
 * @property-read string $webcust
 * @property-read string $def_price_list
 * @property-read string $def_pmt_terms
 * @property-read boolean $cust_txbl
 * @property-read string $last_ord_date
 * @property-read string $last_chk_date
 * @property-read float $last_chk_amt
 * @property-read string $date_created
 * @property-read string $date_modified
 * @property-read string $deleted_at
 * @property-read Collection|Order[] $orders
 * @property-read Collection|CustomerShippingAddress[] $shipping_addresses
 * @property-read mixed $id_string
 * @property-read Customer $customer
 * @property-read Division $divisionRelation
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereDivision($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereCustName($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereBillCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereBilltoCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereBillCustName($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereParentCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereParentCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereParentCustName($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereCustType($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereCustomertypechannelId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereSalesRep($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereSalesGroup($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereSalesMgr($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereActive($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereWebcust($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereDefPriceList($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereDefPmtTerms($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereCustTxbl($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereLastOrdDate($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereLastChkDate($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereLastChkAmt($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereDeletedAt($value)
 * @mixin Eloquent
 * @property-read string $sales_rep_2
 * @property-read string $support_rep
 * @property-read string $support_rep_2
 * @property-read integer $credit_limit
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereSalesRep2($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereSupportRep($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereSupportRep2($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereCreditLimit($value)
 * @property-read integer $primarysales_salesrep_id
 * @property-read integer $secondarysales_salesrep_id
 * @property-read integer $primarysupport_salesrep_id
 * @@property-read integer $secondarysupport_salesrep_id
 * @property-read integer $paymentterms_id
 * @property-read string $date_uploaded
 * @property-read string $facility_id
 * @property-read string $default_shipfrom_id
 * @property-read string $def_ship_from
 * @property-read string $def_ship_policy
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment wherePrimarysalesSalesrepId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereSecondarysalesSalesrepId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment wherePrimarysupportSalesrepId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereSecondarysupportSalesrepId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment wherePaymenttermsId($value)
 * @method static \Illuminate\Database\Query\Builder|CustomerSegment whereDateUploaded($value)
 * @property-read SalesRep $primarySupportPerson
 * @property-read string $m3_division_code
 * @property-read string $discount_model
 * @property-read string $discount_group
 * @property-read string $def_pricelist_desc
 * @property-read string $pricelist_table
 */

class CustomerSegment extends Model
{
	protected $table = 'CustomerSegments';
	use SoftDeletes;

	public function customer() {
		return $this->belongsTo(Customer::class, 'customer_id');
	}

	public function billToCustomer() {
	    $relation = $this->belongsTo(Customer::class, 'billto_customer_id', 'id');
        return $relation;
    }

	public function parentCustomer() {
	    return $this->belongsTo(Customer::class, 'parent_customer_id', 'id');
    }

	public function primarySupportPerson() {
		return $this->belongsTo(SalesRep::class, "primarysupport_salesrep_id");
	}

	public function primarySalesRep() {
	    return $this->belongsTo(SalesRep::class, 'primarysales_salesrep_id');
    }

    public function secondarySalesRep() {
        return $this->belongsTo(SalesRep::class, 'secondarysales_salesrep_id');
    }

	public function orders()
	{
		return $this->hasMany(Order::class, 'soldto_customersegment_id');
	}

	public function shipping_addresses()
	{
		return $this->hasMany(CustomerShippingAddress::class, 'customersegment_id');
	}

	public function address(){
		return $this->belongsTo(CustomerShippingAddress::class,'customershippingaddress_id');
	}

	public function additionalTaxCustomerSegment() {
	    return $this->hasMany(AdditionalTaxCustomerSegment::class, 'customersegment_id')->where('deleted_at', '0000-00-00 00:00:00');
    }

	public function division()
	{
		return $this->hasOne(Division::class);
	}

    /**
     * @return BelongsTo
     */
    public function divisionRelation(): BelongsTo {
        return $this->belongsTo(Division::class, 'division_id', 'id');
    }

	public function facilityDivision() {
        return $this->hasOne(FacilityDivision::class, 'facility_id', 'facility_id');
    }

	public function getBuyingGroupName() {
	    return $this->bill_cust_name;
    }

	public function scopeActive(Builder $query) {
	    return $query->where('active', 1);
    }

    public function getBillsDirectAttribute() {
	    return ($this->billto_customer_id == $this->customer_id);
    }

    public function paymentTerm() {
	    return $this->belongsTo(PaymentTerm::class, 'paymentterms_id');
    }

    public function plant() {
        return $this->belongsTo(Plant::class, 'default_shipfrom_id', 'id');
    }

    public function getIsVegasDefault() {
	    return Plant::LASVEGAS_CODE == $this->def_ship_from ;
    }

    public function assortment() {
        return $this->belongsTo(Assortment::class, 'assortment_id');
    }

    public function getLatestCallAmongAffiliates() {
        return Call::getLatestCallFromListOfCustomers($this->customer->affiliatedCustomers);
    }

    /**
     * @return string|null
     */
    public function getDiscountModel(): ?string {
        return $this->discount_model;
    }

    /**
     * @return string|null
     */
    public function getDiscountGroup(): ?string {
        return $this->discount_group;
    }

    /**
     * @return string|null
     */
    public function getDefaultPriceListDescription(): ?string {
        return $this->def_pricelist_desc;
    }

    /**
     * @return string
     */
    public function getBillCustNo() {
        return $this->bill_cust_no;
    }

    /**
     * @return string|null
     */
    public function getPriceListTable(): ?string {
        return $this->pricelist_table;
    }

    /**
     * @return string
     */
    public function getFacilityCode() {
        return $this->facility_id;
    }

    /**
     * @return string
     */
    public function getCustNo() {
        return $this->cust_no;
    }
}