<?php

use Illuminate\Support\Facades\Storage;

if (! function_exists('assetImage')) {
    /**
     * Return Image Path.
     *
     * @param  string  $path
     * @return string
     */
    function assetImage($path) {
        $assets = Storage::disk('assets');
        if ($assets->has($path)) {
            return $assets->url($path);
        } else {
            return asset('images/nopic.png');
        }
    }
}