<?php

namespace Hilco\Models;

class AdminPermission extends WebModel
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'Permissions';
	protected $fillable = ['permission_title', 'permission_slug', 'permission_description', 'is_enabled'];

	public function users()
	{
		return $this->belongsToMany(WebUser::class, 'Permission_WebUser');
	}

	public function roles()
	{
		return $this->belongsToMany(Role::class, 'Permission_Role', 'permission_id', 'role_id');
	}
}