<?php
namespace Hilco\Models;

/**
 * Created by PhpStorm.
 * User: jmartinez
 * Date: 5/18/2017
 * Time: 3:40 PM
 */
class PromotionShippingDiscountAction extends PromotionActionDetails {
    protected $table = 'PromotionShippingDiscountActions';
    protected $fillable = ['is_percent', 'amount', 'commit_sequence'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'action',
                                'PromotionActions', 'promotion_id',
                        'promotionshippingdiscountaction_id');
    }

    public function calculateShippingDiscount ($rate) {
        if ($this->is_percent) {
            return round(($rate * $this->amount / 100), 2);
        } else {
            return $this->amount;
        }
    }

    public function takeAction(Customer $soldToCustomer, $webCartItems, &$status) {
        // TODO: Implement takeAction() method.
    }

}