<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/22/17
 * Time: 12:48 PM
 */

namespace Hilco\Shipments;

use Hilco\Models\Carrier;

class Rate {
    /**
     * @var Carrier
     */
    protected $carrier;

    /**
     * @var float
     */
    protected $baseRate;

    /**
     * @var float
     */
    protected $discountAmount;

    protected $overrideText;

    /**
     * @var float
     */
    protected $taxAmount;

    /**
     * @var boolean
     */
    protected $isDefault;

    public $selected;
    /**
     * Rate constructor.
     * @param Carrier $carrier
     * @param float $baseRate
     * @param float $discountAmount
     * @param float $taxAmount
     * @param float $rate
     * @param bool $isDefault
     */
    public function __construct($carrier, $baseRate, $isDefault = false, $discountAmount = 0, $taxAmount = 0) {
        $this->carrier = $carrier;
        $this->baseRate = $baseRate;
        $this->discountAmount = $discountAmount;
        $this->taxAmount = $taxAmount;
        $this->isDefault = $isDefault;
        $this->overrideText = false;
        $this->selected = false;
    }

    public function setText($text) {
        $this->overrideText = $text;
    }

    public function code() {
        return array_get($this->carrier, 'carrier_code', -1);
    }

    public function isError() {
        return $this->code() === -1;
    }

    public function rate() {
        if ($this->isError()) return 0;
        return $this->baseRate - $this->discountAmount + $this->taxAmount;
    }

    public function displayText() {
        if ($this->isError()) return trans('hilco::app.unable_to_calculate_shipping_rates');

        if ($this->overrideText) {
            $displayText = $this->overrideText;
        } else {
            $displayText = array_get($this->carrier, 'carrier_desc');
        }

        if ($this->isDefault) $displayText .= ' '.trans('hilco::app.default_parentheses');
        return $displayText;
    }

    public function carrier() {
        return $this->carrier;
    }

    public function isDefault() {
        return $this->isDefault;
    }

    public function isDiscounted() {
        return $this->discountAmount > 0;
    }

    public function discountAmount() {
        return $this->discountAmount;
    }

    public function taxAmount() {
        return $this->taxAmount;
    }

    public function baseRate() {
        return $this->baseRate;
    }
}