<?php

namespace Hilco\Models;

/**
 * Hilco\Models\SupportedJwtSsoParam
 * @property-read string $query_param
 * @property-read string $payload_user_field
 * @property-read string $matched_webuser_field
 * @property-read string $shared_secret
 */
class SupportedJwtSsoParam extends WebModel {
    protected $table = "SupportedJwtSsoParams";

    /**
     * @return string
     */
    public function getQueryParam(): string {
        return $this->query_param;
    }

    /**
     * @return string
     */
    public function getPayloadUserField(): string {
        return $this->payload_user_field;
    }

    /**
     * @return string
     */
    public function getMatchedWebUserField(): string {
        return $this->matched_webuser_field;
    }

    /**
     * @return string
     */
    public function getSharedSecret(): string {
        return $this->shared_secret;
    }
}