<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\Auth;
use DB;

/**
 * Hilco\Models\WebLink
 *
 * @property integer $id
 * @property integer $web_link_category_id
 * @property string $links
 * @property string $type
 * @property string $date_modified
 * @property string $deleted_at
 */
class WebLink extends WebModel {
    protected $table = "WebLinks";
    protected $fillable = ['user_visibility', 'link','type','order','display_name','webSiloIds','web_link_category_id', 'en_name', 'fr_name'];
    public static $userVisibility = ['Hidden', 'Visible For All', 'For Anonymous User', 'For Logged In User'];
    public static $types =[
//        'hilco-route' => 'Hilco Route',
        'landing_page' => 'Landing Page',
//        'asset' => 'Asset',
        'general' => 'Any URL',
    ];
    public static $typeValues = [
//        'hilco-route',
        'landing_page',
        'asset',
        'general',
    ];

    /**
     * @return BelongsToMany
     */
//    public function webSilos() {
//        return $this->belongsToMany(WebSilo::class, 'WebLink_WebSilo', 'weblink_id', 'websilo_id')
//            ->withPivot(['is_visible', 'display_name', 'type', 'link']);
//    }

    public function webLinkWebSiloJoins() {
        return $this->hasMany(WebLink_WebSilo::class, 'weblink_id', 'id');
    }

//    public function getActiveWebSiloAttribute() {
//        return $this->webSilos->where('id', b2b()->activeWebSilo()->id)->first();
//    }

    public function category() {
        return $this->belongsTo(WebLinkCategory::class, 'web_link_category_id');
    }

//    public function setWebSiloIdsAttribute($ids) {
//        $this->save();
//        $this->webSilos()->sync($ids);
//    }

    public function getUrl(){
        if ($this->type == 'landing_page') {
            $url = route('landingpage.slug', [$this->link]);
        } else if ($this->type == 'asset') {
            $url = config('hilco.assets.url');
            $url .= '/' . $this->link;
        } else {
            $url = url($this->link);
        }

        return $url;
    }

//    public function getTypeAttribute() {
//        $siloType = array_get($this, 'activeWebSilo.pivot.type', '');
//        if (strlen($siloType)) return $siloType;
//
//        return $this->attributes['type'];
//    }

//    public function getLinkAttribute() {
//        $siloLink = array_get($this, 'activeWebSilo.pivot.link', '');
//        if (strlen($siloLink)) return $siloLink;
//
//        return $this->attributes['link'];
//    }

//    public function getDisplayNameAttribute() {
//        $siloDisplayName = array_get($this, 'activeWebSilo.pivot.display_name', '');
//        if (strlen($siloDisplayName)) return $siloDisplayName;
//
//        return $this->attributes['display_name'];
//    }

    public function scopeAvailableForUser($query){
        $user = Auth::user();
        if(isset($user)){
            $query = $query->where(function($query){
                return $query->where('WebLinks.user_visibility',1)->orWhere('WebLinks.user_visibility',3);
            });
        }else{
            $query = $query->where(function($query){
                return $query->where('WebLinks.user_visibility',1)->orWhere('WebLinks.user_visibility',2);
            });
        }
        $webSilo = b2b()->activeWebSilo();
//        $activePlant = b2b()->activePlant();
        $query->whereHas('webLinkWebSiloJoins', function ($query) use ($webSilo) {
            return $query
                ->where('websilo_id', '=', $webSilo->id)
//                ->where(function ($where) use ($activePlant) {
//                    return $where
//                        ->where('plant_id', '=', $activePlant->id)
//                        ->orWhere('plant_id', '=', '-1')
//                    ;
//                })
                ->where('WebLink_WebSilo.is_visible', '=', 1)
            ;
        });

        return $query;
//            ->leftJoin('WebLink_WebSilo as WLWS', 'WLWS.weblink_id', '=', 'WebLinks.id')
//            ->leftJoin('WebSilos as WS', 'WS.id', '=', 'WLWS.websilo_id')
//            ->select(DB::raw('WebLinks.*'));
    }

    public function getDisplayNameAttribute() {
        $translatedName = $this->getTranslation('name');
        if (!strlen($translatedName)) $translatedName = $this->attributes['display_name'];
        return $translatedName;
    }

    public function getDisplayNameForUACAttribute() {
        return $this->getDisplayNameAttribute();
    }
    use HasModelTranslations;

}
