<?php

namespace Hilco\Models;

use DB;
use Hilco\Models\SelectsRelatedCount;

class WebAttribute_WebPart extends WebModel
{
	protected $table = 'WebAttribute_WebPart';
	protected $fillable = ['attribute_value', 'buckets'];

	public function webPart() {
		return $this->belongsTo(WebPart::class, 'webpart_id', 'id');
	}

	public function webAttribute() {
		return $this->belongsTo(WebAttribute::class, 'webattribute_id', 'id');
	}

    public function scopeInFamily($query, $webFamily) {
        $webFamilyId = ($webFamily instanceof WebFamily) ? $webFamily->id : $webFamily;
        return $query->whereHas('webPart', function ($query) use ($webFamilyId) {
            return $query->inFamily($webFamilyId);
        });
    }

    public function scopeInCollection($query, $webCollection) {
        $webCollectionId = ($webCollection instanceof WebCollection) ? $webCollection->id : $webCollection;
        return $query->whereHas('webPart', function ($query) use ($webCollectionId) {
            return $query->inCollection($webCollectionId);
        });
    }

    public function scopeInCategory($query, $webCategory) {
        $webCategoryId = ($webCategory instanceof WebCategory) ? $webCategory->id : $webCategory;
        return $query->whereHas('webPart', function ($query) use ($webCategoryId) {
            return $query->inCategory($webCategoryId);
        });
    }

    public function scopeInGroup($query, $webGroup) {
        $webGroupId = ($webGroup instanceof WebGroup) ? $webGroup->id : $webGroup;
        return $query->whereHas('webPart', function ($query) use ($webGroupId) {
            return $query->inGroup($webGroupId);
        });
    }

    public function scopeIn($query, $model) {
        if ($model instanceof WebGroup) $query->inGroup($model);
        else if ($model instanceof WebCategory) $query->inCategory($model);
        else if ($model instanceof WebCollection) $query->inCollection($model);
        else if ($model instanceof WebFamily) $query->inFamily($model);
        $query->with('webAttribute')
            ->join('WebParts', 'WebParts.id', '=', 'WebAttribute_WebPart.webpart_id')
            ->join('WebAttribute_WebFamily', function ($ons) {
                $ons
                    ->on('WebAttribute_WebFamily.webattribute_id', '=', 'WebAttribute_WebPart.webattribute_id')
                    ->on('WebAttribute_WebFamily.webfamily_id', '=', 'WebParts.webfamily_id')
                ;
            });
        return $query;
    }

    public function staticSearchBuckets()
    {
        return $this->belongsToMany(SearchBucketStatic::class, 'SearchBucketStatic_WebAttributeValue', 'webattributevalue_id', 'searchbucket_id');
    }

    public function setBucketsAttribute($bucketIds) {

        $currentBuckets = SearchBucketStatic_WebAttributeValue::where('webattributevalue_id', '=', $this->id)->distinct('searchbucket_id')->pluck('searchbucket_id');

        if(!$currentBuckets->isempty()){
            $bucketsToRemove = array_diff($currentBuckets->all(), $bucketIds);
            $bucketsToAdd = array_diff($bucketIds, $currentBuckets->all());


            foreach($bucketsToRemove as $bucketToRemove){
                $oldBucket = SearchBucketStatic_WebAttributeValue::where('webattributevalue_id', '=', $this->id)->where('searchbucket_id', '=', $bucketToRemove)->first();
                $oldBucket->delete();
            }
        }else{
            $bucketsToAdd = $bucketIds;
        }

        foreach($bucketsToAdd as $bucketToAdd){
            $existingBucket = SearchBucketStatic_WebAttributeValue::where('webattributevalue_id', '=', $this->id)->where('searchbucket_id', '=', $bucketToAdd)->withTrashed()->first();
            if($existingBucket != null){
                $existingBucket->restore();
                $existingBucket->save();
            }else{
                $searchBucketValue = new SearchBucketStatic_WebAttributeValue();
                $searchBucketValue->searchbucket_id = $bucketToAdd;
                $searchBucketValue->webattributevalue_id = $this->id;
                $searchBucketValue->save();
            }

        }
    }

    public function setBucketIdsAttribute($ids) {
        return $this->setBucketAttribute($ids);
    }

    public function getAttributeValueAttribute() {
        if (config('hilco.ignoreActiveWebSilo')) {
            return $this->getTranslation('attribute_value', AvailableLanguage::DEFAULT_LANG_CODE, $this->attributes['attribute_value']);
        } else {
            return $this->getTranslation('attribute_value');
        }
    }

    use HasModelTranslations;
}