<?php

namespace Hilco\Models;

/**
 * Hilco\Models\FeedbackSubject
 *
 * @property mixed $id
 * @property string $feedback_type_id
 * @property string $feedback_subject_text
 * @property string $feedback_subject_displayOrder
 * @property string $deleted_at
 * @property string $date_created
 * @property string $date_modified
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackSubject whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackSubject whereFeedbackTypeId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackSubject whereFeedbackSubjectText($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackSubject whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackSubject whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackSubject whereDeletedAt($value)
 * @mixin \Eloquent
 */
class FeedbackSubject extends WebModel
{
    protected $table = 'FeedbackSubjects';

    public function feedbackType()
    {
        $this->belongsTo(FeedbackType::class, 'feedback_type_id');
    }

    public function webFeedbackResponses()
    {
        return $this->hasMany(WebFeedbackResponse::class, 'feedback_subject_id');
    }

    public function getFeedBackSubjectAttribute() {
        return $this->getTranslation('feedback_subject_text', b2b()->activeLanguage(), $this->attributes['feedback_subject_text']);
    }

    public function getDisplayNameForUACAttribute() {
        return $this->getFeedBackSubjectAttribute();
    }

    use HasModelTranslations;
}
