<?php
/**
 * Created by PhpStorm.
 * User: ntaylor-visionware
 * Date: 11/15/17
 * Time: 5:31 PM
 */

namespace Hilco\Models;


class PromotionCurrentOrderTrigger_Product extends WebModel {
    protected $table = 'PromotionCurrentOrderTrigger_Product';
    protected $fillable = ['excluded', 'commit_sequence'];

    public function currentOrderTrigger() {
        return $this->belongsTo(PromotionCurrentOrderTrigger::class,
                            'promotioncurrentordertrigger_id', 'id');
    }

    public function scopeTriggerProduct($query, $trigger_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotioncurrentordertrigger_id' => $trigger_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;
}