<div class="panel panel-info">
    <div class="panel-body">
        <a href="{{ route('rewards.status') }}">
            <div class="row">
                @if(rewards()->tier() >= 2)
                    <div class="col-sm-3 col-lg-2">
                        <img src="{{ rewards()->tierImage() }}" class="img-responsive center-block" style="min-height: 80px" alt="">
                    </div>
                @endif
                <div class="@if(rewards()->tier() >= 2) col-sm-9 col-lg-10 @else col-xs-12 @endif">
                    <h4 class="text-center" style="margin-top: 0;">@lang('hilco::app.your_hilco_vision_partnership_rewards_status')</h4>
                    <div class="text-right" style="color: #c0c0c0; font-weight: bold; border-right: 1px solid #c0c0c0; float: left; width: 33%">
                        @lang('hilco::app.silver')  <i class="fa fa-arrow-right"></i>&nbsp;
                    </div>
                    <div class="text-right" style="color: #daa520; font-weight: bold; border-right: 1px solid #daa520; float: left; width: 34%">
                        @lang('hilco::app.gold')  <i class="fa fa-arrow-right"></i>&nbsp;
                    </div>
                    <div class="text-right" style="color: #778899; font-weight: bold; border-right: 1px solid #778899; float: left; width: 33%">
                        @lang('hilco::app.platinum') <i class="fa fa-arrow-right"></i>&nbsp;
                    </div>
                    <div class="clearfix"></div>
                    <div class="progress progress-rewards" style="margin-bottom: 1em;">
                        <div
                                data-qtip-id="details-qtip" class="rewards-progress-bar progress-bar @if(rewards()->tier() == 1) progress-bar-success @elseif(rewards()->tier() == 2) rewards-silver @elseif(rewards()->tier() == 3) rewards-gold @elseif(rewards()->tier() == 4) rewards-platinum @else progress-bar-info @endif "
                                style="width: {{ rewards()->statusPercentage() * 100 }}%"
                        >
                            <strong class="pull-right">
                                @if(rewards()->statusPercentage() * 100 < 20)
                                    @lang('hilco::app.you')&nbsp;&nbsp;
                                @else
                                    @lang('hilco::app.your_spending_colon_x', ['amount' => number_format(rewards()->totalSpending(), 2)]) &nbsp;&nbsp;
                                @endif
                            </strong>
                        </div>
                        <div style="display: none;" id="details-qtip">
                            @lang('hilco::app.your_spending_colon_x', ['amount' => number_format(rewards()->totalSpending(), 2)])&nbsp;&nbsp;
                        </div>
                        @foreach(rewards()->potential() as $cats => $pct)
                            <div data-qtip-id="potential-{{$cats}}" class="rewards-progress-bar progress-bar boost-{{ $cats }}" style="width: {{ $pct * 100 }}%">
                                + {{ $cats - rewards()->qualifyingCategories() }}
                            </div>
                            <div style="display: none;" id="potential-{{$cats}}">
                                {{ trans_choice('hilco::app.qualify_in_x_more_categories_and_boost_your_status', $cats - rewards()->qualifyingCategories(), ['categories' => $cats - rewards()->qualifyingCategories()]) }}
                            </div>
                        @endforeach
                    </div>
                    @if(!rewards()->qualifiedForTier())
                        <p style="color: red; font-weight: bold">@lang(trans_choice('hilco::app.you_are_at_risk_of_being_downgraded', rewards()->calculateCategoriesToMaintainTier(), ['amountMaintain' => rewards()->calculateSpendingToMaintainTier(), 'categoriesMaintain' => rewards()->calculateCategoriesToMaintainTier(), 'downgradeDate' => rewards()->downgradeDate(), 'tierName' => rewards()->tierName()]))</p>
                    @endif
                    @if(rewards()->tier() < 4 && rewards()->qualifiedForTier())
                        <p>@lang(trans_choice('hilco::app.increase_your_discount_by_spending_more', rewards()->calculateCategoriesToUpgrade(),['amountUpgrade' => rewards()->calculateSpendingToUpgrade(), 'categoriesUpgrade' => rewards()->calculateCategoriesToUpgrade()]))</p>
                    @endif
                </div>
            </div>
        </a>
    </div>
</div>