<?php
/**
 * Created by PhpStorm.
 * User: ntaylor-visionware
 * Date: 5/30/18
 * Time: 2:44 PM
 */

namespace Hilco\Models;


class PromotionFreeItemAction_Product extends WebModel {
    protected $table = 'PromotionFreeItemAction_Product';
    protected $fillable = ['excluded', 'commit_sequence'];

    public function freeItemAction() {
        return $this->belongsTo(PromotionFreeItemAction::class,
            'promotionfreeitemaction_id', 'id');
    }

    public function scopeActionProduct($query, $action_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotionfreeitemaction_id' => $action_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;
}