<?php

namespace Hilco\Models;

/**
 * Hilco\Models\Division
 *
 * @property mixed $id
 * @property string $division
 * @property string $division_name
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Customer[] $customers
 * @property-read mixed $id_string
 * @property-read string $division_trimmed
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDivision($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDivisionName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDateUploaded($value)
 */
class Division extends WebModel {
	protected $table = 'Divisions';

	const AU_CODE = 'U02';
	const DE_CODE = 'DO1';
    const UK_CODE = 'G01';
    const US_CODE = 'U01';

//	const UK_DIVISION       = 'HILCO-UK';
//	const US_DIVISION       = 'HILCO-US';
//	const WILSON_DIVISION   = 'WILSON-US';

    public function getDivisionTrimmedAttribute() {
        return trim(substr($this->division, strpos($this->division, '_') + 1));
    }
}
