<?php

namespace Hilco\M3Helper\ResponseModels;

/**
 * Class MessageResponseModel
 * @package Hilco\M3Helper\ResponseModels
 *
 * Example:
 * {
 *      "Message": "Item number 1080053 does not exist",
 *      "@type": "ServerReturnedNOK",
 *      "@code": "WIT0103",
 *      "@cfg": null,
 *      "@field": null
 * }
 */
class MessageResponseModel extends GenericM3ResponseModel {
    /**
     * @var string
     */
    private $message;

    /**
     * @var string
     */
    private $type;

    /**
     * @var string
     */
    private $code;

    /**
     * @var
     */
    private $cfg;

    /**
     * @var
     */
    private $field;

    /**
     * MessageResponseModel constructor.
     * @param $responseObj
     */
    public function __construct($responseObj) {
        $this->message = trim($responseObj['Message']);
        $this->type = $responseObj['@type'];
        $this->code = $responseObj['@code'];
        $this->cfg = $responseObj['@cfg'];
        $this->field = $responseObj['@field'];
        parent::__construct($responseObj);
    }

    /**
     * @return string
     */
    public function getMessage() {
        return $this->message;
    }

    /**
     * @return string
     */
    public function getType() {
        return $this->type;
    }
}