<?php

namespace Hilco\Models;

use DB;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * M3 discounts matrix
 * @property-read string $DISP
 */
class OGDMTX extends Model {
    protected $table = "OGDMTX";
    protected $connection = "hilco-pricelist";

    /**
     * @return string
     */
    public function getDiscountPercentage() {
        return $this->DISP;
    }

    /**
     * @param $discModel , e.g., "DISC_USD" (CustomerSegments.discount_model)
     * @param $discBucketNo , e.g., 4 (OGDIPO.DIPO)
     * @param $priorityLevel , e.g., 7 (the 3rd character in the 4-character PC** column names in OGDIPO -- "PC73" would be the 3rd rule in priority level 7)
     * @param $rule1Val
     * @param $rule2Val
     * @param $rule3Val
     * @param $rule4Val
     * @param $rule5Val
     * @param int $quantity
     * @return OGDMTX|null
     */
    public static function findDiscountRecord ($discModel, $discBucketNo, $priorityLevel, $rule1Val, $rule2Val, $rule3Val, $rule4Val, $rule5Val, int $quantity = 1): ?OGDMTX {
        return
            OGDMTX::where('DISY', "$discModel")
                    ->where('DIPO', "$discBucketNo")
                    ->where('PREX', "$priorityLevel")
                    ->where("OBV1", "$rule1Val")
                    ->where("OBV2", "$rule2Val")
                    ->where("OBV3", "$rule3Val")
                    ->where("OBV4", "$rule4Val")
                    ->where("OBV5", "$rule5Val")
                    ->where('LIMT', '<=', $quantity)
                    ->where('FVDT', '<=', DB::raw("DATE_FORMAT(CURDATE(), '%Y%m%d')"))
                    ->orderBy('LIMT', 'DESC')
                    ->limit(1)
                    ->first();
    }
}