<?php

namespace Hilco\Models;

use Auth;
use DB;
use Debugbar;
use Exception;
use HilcoB2B\M3Request;
use Hilco\GuzzleWrappers\APIGuzzleWrapper;
use Illuminate\Database\Eloquent\Model;
use Log;

class SubscriptionGroup extends UuidModel
{
    protected $table = 'SubscriptionGroups';


    public function soldToCustomer() {
        return $this->hasOne(Customer::class, 'id', 'soldto_customer_id');
    }

    public function billToCustomer() {
        return $this->hasOne(Customer::class, 'id', 'billto_customer_id');
    }

    public function customerShippingAddress() {
        return $this->hasOne(CustomerShippingAddress::class, 'id', 'customershippingaddress_id');
    }

    public function createdByWebUser() {
        return $this->hasOne(WebUser::class, 'id', 'createdby_webuser_id');
    }
    public function modifiedByWebUser() {
        return $this->hasOne(WebUser::class, 'id', 'lastmodifiedby_webuser_id');
    }

    public function subscriptionItems() {
        return $this->hasMany(SubscriptionItem::class, 'subscriptiongroup_id', 'id');
    }

    public function subscriptionPeriod() {
        return $this->hasOne(SubscriptionPeriod::class, 'id', 'subscriptionperiod_id');
    }

    public static function sendKlaviyoEventForSubscriptionGroup($eventName, $subscriptionGroup, $changedItem = null) {
        $client = new Klaviyo(config('klaviyo.private_key'), config('klaviyo.public_key'));

        $itemArray = [];
        foreach($subscriptionGroup->subscriptionItems as $subscriptionItem) {
            $part = $subscriptionItem->part;
            $webFamily = $part->webFamily;
            $webPart = $part->webPart;
            $itemArray[] = [
                'ProductID' => $part->part_no,
                'ProductName' => $part->part_desc,
                'Quantity' => $subscriptionItem->quantity,
                'ProductURL' => route('family.slug', [Arr::get($webFamily, 'slug', ''), Arr::get($webPart, 'id', '')]),
                'SmallImageURL' => WebAsset::urlHelper(['key' => Arr::get($part, 'part_no', ''), 'prefix' => 'pn', 'width' => 150, 'height' => 150]),
                'ImageURL' => WebAsset::urlHelper(['key' => Arr::get($part, 'part_no', ''), 'prefix' => 'pn']),
            ];
        }


        if ($changedItem != null) {
            $event = new KlaviyoEvent([
                'event' => $eventName,
                'customer_properties' => [
                    '$id' => $subscriptionGroup->modifiedByWebUser->id,
                    '$email' => $subscriptionGroup->modifiedByWebUser->email
                ],
                'properties' => [
                    'group_name' => $subscriptionGroup->label,
                    'next_order_date' => $subscriptionGroup->next_order_date,
                    'cadence' => $subscriptionGroup->subscriptionPeriod->period_name,
                    'delayed_counter' => $subscriptionGroup->delayed_counter,


                    'billto_customer_number' => $subscriptionGroup->billToCustomer->cust_no,
                    'billto_customer_name' => $subscriptionGroup->billToCustomer->cust_name,
                    'billto_addr_1' => $subscriptionGroup->billToCustomer->bill_addr_1,
                    'billto_addr_2' => $subscriptionGroup->billToCustomer->bill_addr_2,
                    'billto_addr_3' => $subscriptionGroup->billToCustomer->bill_addr_3,
                    'billto_addr_4' => $subscriptionGroup->billToCustomer->bill_addr_4,
                    'billto_addr_5' => $subscriptionGroup->billToCustomer->bill_addr_5,
                    'billto_city' => $subscriptionGroup->billToCustomer->bill_city,
                    'billto_state' => $subscriptionGroup->billToCustomer->bill_state,
                    'billto_zip' => $subscriptionGroup->billToCustomer->bill_zip_postal,
                    'billto_country' => $subscriptionGroup->billToCustomer->bill_country,

                    'shipto_addr_number' => $subscriptionGroup->customerShippingAddress->addr_no,
                    'shipto_customer_name' => $subscriptionGroup->customerShippingAddress->cust_name,
                    'shipto_addr_1' => $subscriptionGroup->customerShippingAddress->addr_1,
                    'shipto_addr_2' => $subscriptionGroup->customerShippingAddress->addr_2,
                    'shipto_addr_3' => $subscriptionGroup->customerShippingAddress->addr_3,
                    'shipto_addr_4' => $subscriptionGroup->customerShippingAddress->addr_4,
                    'shipto_addr_5' => $subscriptionGroup->customerShippingAddress->addr_5,
                    'shipto_city' => $subscriptionGroup->customerShippingAddress->city,
                    'shipto_state' => $subscriptionGroup->customerShippingAddress->state,
                    'shipto_zip' => $subscriptionGroup->customerShippingAddress->postal_cd,
                    'shipto_country' => $subscriptionGroup->customerShippingAddress->country,

                    'items' => $itemArray,
                    'changedItem' => $changedItem,
                ],
            ]);
        } else {
            $event = new KlaviyoEvent([
                'event' => $eventName,
                'customer_properties' => [
                    '$id' => $subscriptionGroup->modifiedByWebUser->id,
                    '$email' => $subscriptionGroup->modifiedByWebUser->email
                ],
                'properties' => [
                    'group_name' => $subscriptionGroup->label,
                    'next_order_date' => $subscriptionGroup->next_order_date,
                    'cadence' => $subscriptionGroup->subscriptionPeriod->period_name,
                    'delayed_counter' => $subscriptionGroup->delayed_counter,


                    'billto_customer_number' => $subscriptionGroup->billToCustomer->cust_no,
                    'billto_customer_name' => $subscriptionGroup->billToCustomer->cust_name,
                    'billto_addr_1' => $subscriptionGroup->billToCustomer->bill_addr_1,
                    'billto_addr_2' => $subscriptionGroup->billToCustomer->bill_addr_2,
                    'billto_addr_3' => $subscriptionGroup->billToCustomer->bill_addr_3,
                    'billto_addr_4' => $subscriptionGroup->billToCustomer->bill_addr_4,
                    'billto_addr_5' => $subscriptionGroup->billToCustomer->bill_addr_5,
                    'billto_city' => $subscriptionGroup->billToCustomer->bill_city,
                    'billto_state' => $subscriptionGroup->billToCustomer->bill_state,
                    'billto_zip' => $subscriptionGroup->billToCustomer->bill_zip_postal,
                    'billto_country' => $subscriptionGroup->billToCustomer->bill_country,

                    'shipto_addr_number' => $subscriptionGroup->customerShippingAddress->addr_no,
                    'shipto_customer_name' => $subscriptionGroup->customerShippingAddress->cust_name,
                    'shipto_addr_1' => $subscriptionGroup->customerShippingAddress->addr_1,
                    'shipto_addr_2' => $subscriptionGroup->customerShippingAddress->addr_2,
                    'shipto_addr_3' => $subscriptionGroup->customerShippingAddress->addr_3,
                    'shipto_addr_4' => $subscriptionGroup->customerShippingAddress->addr_4,
                    'shipto_addr_5' => $subscriptionGroup->customerShippingAddress->addr_5,
                    'shipto_city' => $subscriptionGroup->customerShippingAddress->city,
                    'shipto_state' => $subscriptionGroup->customerShippingAddress->state,
                    'shipto_zip' => $subscriptionGroup->customerShippingAddress->postal_cd,
                    'shipto_country' => $subscriptionGroup->customerShippingAddress->country,

                    'items' => $itemArray,
                ],
            ]);
        }

        $client->publicAPI->track($event);
    }
}