<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use LogicException;

class PromotionItemDiscountAction extends WebModel
{
    protected $table = 'PromotionItemDiscountActions';
    protected $fillable = ['quantity_to_discount', 'discount_percent'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'action', 'PromotionActions', 'promotion_id', 'promotionitemdiscountaction_id');
    }

    public function webGroups() {
        return $this
            ->morphedByMany(WebGroup::class, 'product', 'PromotionItemDiscountAction_Product')
            ->withPivot(['excluded'])
        ;
    }

    public function webCategories() {
        return $this
            ->morphedByMany(WebCategory::class, 'product', 'PromotionItemDiscountAction_Product')
            ->withPivot(['excluded'])
        ;
    }

    public function webCollections() {
        return $this
            ->morphedByMany(WebCollection::class, 'product', 'PromotionItemDiscountAction_Product')
            ->withPivot(['excluded'])
        ;
    }

    public function webFamilies() {
        return $this
            ->morphedByMany(WebFamily::class, 'product', 'PromotionItemDiscountAction_Product')
            ->withPivot(['excluded'])
        ;
    }

    public function webParts() {
        return $this
            ->morphedByMany(WebPart::class, 'product', 'PromotionItemDiscountAction_Product')
            ->withPivot(['excluded'])
            ;
    }
}
