<?php

namespace Hilco\Models;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;


/**
 * Hilco\Models\Customer
 *
 * @property integer $id
 * @property string $cust_no
 * @property string $cust_name
 * @property string $aff_cust_no
 * @property integer $aff_customer_id
 * @property string $aff_cust_name
 * @property string $addr_1
 * @property string $addr_2
 * @property string $addr_3
 * @property string $addr_4
 * @property string $addr_5
 * @property string $city
 * @property string $state
 * @property string $zip_postal
 * @property string $country
 * @property string $category
 * @property integer $customercategory_id
 * @property string $incept_dt
 * @property string $currency
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Division[] $divisions
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\CustomerPhone[] $phones
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\CustomerEmail[] $emails
 * @property-read \Hilco\Models\CustomerCategory $customer_category
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\CustomerContact[] $contacts
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\CustomerDiscount[] $discounts
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Order[] $orders
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCustName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAffCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAffCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAffCustName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAddr1($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAddr2($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAddr3($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAddr4($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAddr5($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCity($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereState($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereZipPostal($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCountry($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCategory($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCustomercategoryId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereInceptDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCurrency($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereDeletedAt($value)
 * @mixin \Eloquent
 */
class Customer extends Model
{
	protected $table = 'Customers';
	protected $fillable = ['name', 'country', 'state', 'city', 'zip_postal', 'addr_1', 'addr_2', 'addr_3','currency','cust_name'];
	public static $currencies = [
		'USD'=>'USD',
		'NZD'=>'NZD',
		'JPY'=>'JPY',
		'GBP'=>'GBP',
		'CNY'=>'CNY',
		'CAD'=>'CAD',
		'AUD'=>'AUD'
	];
	const UPDATED_AT = 'date_modified';

    use \Hilco\SoftDeletes;

	public function webUser()
	{
		return $this->hasOne(WebUser::class, 'customer_id');
	}

	public function shippingAddresses() {
		return $this->hasMany(CustomerShippingAddress::class, 'cust_no', 'cust_no');
	}

	public function contacts() {
	    return $this->hasMany(Contact::class, 'customer_id', 'id');
    }

    public function customerEmails() {
        return $this->hasMany(CustomerEmail::class, 'customer_id', 'id');
    }

	public static $priority = [
		'A'	=> [
			'from' => 2000,
			'to'   => 9999999
		],
		'B'	=> [
			'from' => 1000,
			'to'   => 1999
		],
		'C'	=> [
			'from' => 400,
			'to'   => 999
		],
		'D'	=> [
			'from' => 0,
			'to'   => 399
		]
	];

//	public function user()
//	{
//		return $this->hasOne(User::class, 'customer_id');
//	}

    public function getActiveSegmentAttribute() {
        return $this->segments->where('active', 1)->first();
    }

    public function getDefaultShippingAddressAttribute() {
        $segment = $this->active_segment;
        return is_null($segment) ? null : $segment->address;
    }

	public function activeSegments()
	{
		return $this->segments()->where('CustomerSegments.active', '=', 1);
	}

	public function pharmacyInfo()
	{
		return $this->hasOne(CustomerPharmacyInfos::class, 'customer_id');
	}

	public function segments() {
		return $this->hasMany(CustomerSegment::class, 'customer_id', 'id');
	}

//	public function activeBilltoSegment()
//	{
//		return $this->hasOne(CustomerSegment::class,'billto_customer_id')->where('CustomerSegments.active', '=', 1);
//	}
//
//	public function billtoSegments()
//	{
//		return $this->hasMany(CustomerSegment::class,'billto_customer_id');
//	}

	public function activeDivisions()
	{
		return $this->belongsToMany(Division::class, 'CustomerSegments', 'customer_id', 'division_id')->where('CustomerSegments.active', '=', 1);
	}

	public function divisions()
	{
		return $this->belongsToMany(Division::class, 'CustomerSegments', 'customer_id', 'division_id');
	}

	public function phones()
	{
		return $this->hasMany(CustomerPhone::class);
	}

	public function emails()
	{
		return $this->hasMany(CustomerEmail::class);
	}

	public function customer_category() {
	    return $this->customerCategory;
    }

	public function customerCategory()
	{
		return $this->belongsTo(CustomerCategory::class, 'customercategory_id');
	}

	public function discounts()
	{
		return $this->hasMany(CustomerDiscount::class);
	}

	public function customerStateTax(){
		return $this->belongsTo(StateTax::class,'state','state')
			->where(function($query){
				$query->where(function($query){
					return $query->where('effective_date','<=', date('Y-m-d',time()))
						->where('expiration_date','>=', date('Y-m-d',time()));
				})
					->orWhere('expiration_date', '000-00-00');
			});
	}

	public function customerVATTax(){

	}

	public function orders()
	{
		return $this->hasMany(Order::class, 'soldto_customer_id');
	}

	public function salesStats()
	{
		return $this->hasMany(CustomerSalesStats::class, 'customer_id');
	}

	public function stateTax() {
		return StateTax::where("state", $this->state)->inEffect()->first();
	}

	public function scopeWithEmails($query) {
		return $query->addSelect('email_raw', 'good_email', 'email_note', 'email_news', 'email_sales', 'email_ship')
			->join('CustomerEmails', 'Customers.id', '=', 'CustomerEmails.customer_id')
			;
	}

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
	public function webCustomerSalesSummaries() {
	    return $this->hasMany(WebCustomerSalesSummary::class, 'customer_id', 'id');
    }

    public function webCustomerLimits() {
        return $this->hasMany(WebCustomerLimit::class, 'customer_id', 'id');
    }

    public function recentOrders($count = 5) {
        return $this
            ->orders()
            ->submitted()
            ->with('partLines.orderLineSchedules.shipment', 'partLines.partLine')
            ->orderBy('order_date', 'desc')
            ->take($count)
            ->get();
    }

    public function topPurchasedItems($count = 5) {
        $ids = WebFamily::visible()
            ->join('WebParts', 'WebParts.webfamily_id', '=', 'WebFamilies.id')
            ->join('SalesOrderPartLines', function($join) {
                $join
                    ->on('SalesOrderPartLines.part_id', '=', 'WebParts.part_id');
            })
            ->join('SalesOrderMainLines', function($join) {
                $join
                    ->on('SalesOrderMainLines.parent_id', '=', 'SalesOrderPartLines.id');
            })
            ->join('SalesOrders', function($join) {
                $join
                    ->on('SalesOrderPartLines.salesorder_id', '=', 'SalesOrders.id')
                    ->on('SalesOrderMainLines.salesorder_id', '=', 'SalesOrders.id');
            })
            ->leftJoin('SalesOrderLineSchedules', function($join) {
                $join
                    ->on('SalesOrderLineSchedules.salesorder_id', '=', 'SalesOrders.id')
                    ->on('SalesOrderLineSchedules.salesordermainline_id', '=', 'SalesOrderMainLines.id');
            })
            ->where('SalesOrders.deleted_at', '=', DB::raw('0'))
            ->where('SalesOrderMainLines.deleted_at', '=', DB::raw('0'))
            ->where('SalesOrderPartLines.deleted_at', '=', DB::raw('0'))
            ->where(function ($where) {
                $where
                    ->whereNull('SalesOrderLineSchedules.deleted_at')
                    ->orWhere('SalesOrderLineSchedules.deleted_at', '=', DB::raw('0'))
                ;
            })
            ->where('SalesOrders.soldto_customer_id', '=', $this->id)
            ->whereNotIn('SalesOrders.order_status', ['CANCELLED', 'DISCARDED'])
            ->groupBy('WebFamilies.id')
            ->orderBy(DB::raw('COUNT(DISTINCT SalesOrders.id)'), 'DESC')
            ->take($count)
            ->pluck('WebFamilies.id')
        ;

        return WebFamily::with('assets', 'visibleWebParts.part.customerPrices')->findMany($ids);
    }

    public function affiliateCustomer() {
	    return $this->hasOne(Customer::class, 'id', 'aff_customer_id');
    }

    public function affiliateChildren() {
        return $this->hasMany(Customer::class, 'aff_customer_id', 'id');
    }

    public function getHasAffiliateAttribute() {
	    return !is_null($this->aff_customer_id);
    }

    public function rewardsStatus() {
	    return $this->hasMany(CustomerRewardsStatus::class);
    }

    public function rewardsTier() {
	    return $this->hasOne(CustomerRewardsTier::class)->orderBy('first_qualified_date', 'DESC')->take(1);
    }

    public function rewardsRegistration() {
	    return $this->hasOne(CustomerRewardsRegistration::class, 'customer_id', 'id');
    }

    public function getBillsDirectAttribute() {
	    return $this->activeSegment->billsDirect;
    }

//    const REWARDS_ELIGIBLE = 1;
//	const REWARDS_ACCOUNT_NOT_DIRECT_BILL = -1;
//	const REWARDS_AFFILIATE_NOT_DIRECT_BILL = -2;
//	const REWARDS_INVALID_CUSTOMER_CATEGORY = -3;
//	const REWARDS_EXCLUDED_MEMBER_GROUP = -4;
//	const REWARDS_ALREADY_REGISTERED = -10;
//
//    public function getRewardsEligibilityAttribute() {
//        if ($this->rewardsRegistration) return self::REWARDS_ALREADY_REGISTERED;
//
//	    foreach ($this->affiliateCustomer->affiliateChildren as $affiliate) {
//	        if (!$affiliate->billsDirect) {
//	            return $affiliate->id == $this->id ? self::REWARDS_ACCOUNT_NOT_DIRECT_BILL : self::REWARDS_AFFILIATE_NOT_DIRECT_BILL;
//            }
//        }
//
//        if (!in_array($this->customercategory_id, config('rewards.eligibleCustomerCategoryIds', []))) return self::REWARDS_INVALID_CUSTOMER_CATEGORY;
//
//	    if (in_array($this->member_group, config('rewards.excludedMemberGroups', []))) return self::REWARDS_EXCLUDED_MEMBER_GROUP;
//
//	    return self::REWARDS_ELIGIBLE;
//    }

    public function getRewardsTierLevelAttribute() {
        $tier = $this->rewardsTier;
        if (!is_null($tier)) {
            return $tier->tier;
        }
        return 0;
    }
}
