<?php

namespace Hilco\Models;

use Auth;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Storage;
use Image as Image2;

/**
 * Hilco\Models\Product
 *
 * @property mixed $id
 * @property string $part_no
 * @property string $part_desc
 * @property string $part_upc
 * @property string $upc_w_check
 * @property string $sls_uom
 * @property string $weight_lbs
 * @property string $vol_ci
 * @property boolean $private_lbl
 * @property string $cat_item
 * @property boolean $web_part
 * @property string $incept_dt
 * @property string $pf_prod_mgr
 * @property string $prod_fam_no
 * @property string $product_family
 * @property string $pf_group
 * @property string $fin_rpt_sum
 * @property string $fin_rpt_sub
 * @property string $product_category
 * @property string $product_category_grp
 * @property string $product_category_summ
 * @property string $web_part_desc
 * @property string $web_part_family
 * @property float $list_price
 * @property string $price_group
 * @property string $prod_cat
 * @property string $prod_cat_grp
 * @property string $prod_cat_summ
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Hilco\Models\WebPart $details
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\ProductAttributeValues[] $attributes
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\PriceList[] $prices
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Cart[] $cart_items
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\InventoryItem[] $inventory_items
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePartNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePartDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePartUpc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereUpcWCheck($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereSlsUom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWeightLbs($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereVolCi($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePrivateLbl($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereCatItem($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWebPart($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereInceptDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePfProdMgr($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdFamNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductFamily($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePfGroup($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereFinRptSum($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereFinRptSub($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductCategory($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductCategoryGrp($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductCategorySumm($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWebPartDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWebFamily($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereListPrice($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePriceGroup($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdCat($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdCatGrp($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdCatSumm($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $product_family_no
 * @property mixed $productfamily_id
 * @property string $rx_dose_form
 * @property string $rx_ndc
 * @property float $rx_packsize
 * @property string $rx_strength
 * @property string $vat_code
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductFamilyNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductfamilyId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxDoseForm($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxNdc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxPacksize($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxStrength($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereVatCode($value)
 * @property string $pointman_web_part_desc
 * @property string $pointman_web_part_family
 * @property string $date_uploaded
 * @property-read mixed $web_part_name
 * @property-read mixed $name
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePointmanWebPartDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePointmanWebPartFamily($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part distinctProductManagers()
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part managedBy($product_manager)
 */
class Part extends WebModel
{
	protected $table = 'Parts';
//	protected $appends = ['web_part_name', 'web_part_family'];
//	protected $with = ['details'];
	protected $guarded = ['id'];
	protected $getterMutators = [
//		'id' => 'bin2hex',
		'productfamily_id' => 'bin2hex',
	];
	protected $setterMutators = [
		'productfamily_id' => 'hex2bin',
	];

    const IN_STOCK = 'inStock';
    const OUT_OF_STOCK = 'outOfStock';
    const DELAYED = 'delayed';
    const UNKNOWN = 'unknown';

	public function webPart() {
		return $this->hasOne(WebPart::class, 'part_number', 'part_no');
	}

    /**
     * @return BelongsToMany
     */
	public function webSilos() {
	    return $this->belongsToMany(WebSilo::class, 'WebSilo_Part', 'part_id', 'websilo_id')->withPivot(['require_approval']);
    }

	public function VATTax(){
		return  $this->belongsTo(VATTax::class, 'vat_code', 'vat_code')
				->where(function($query){
					$query->where(function($query){
						return $query->where('effective_date','<=', date('Y-m-d',time()))
							->where('expiration_date','>=', date('Y-m-d',time()));
					})
						->orWhere('expiration_date', '0000-00-00');
				});
	}
	public function details() {
		return $this->webPart();
	}

	public function getWebPartNameAttribute() {
		return is_null($this->details) ? null : $this->details->web_part_name;
	}

	public function getNameAttribute() {
		return is_null($this->web_part_name) ? $this->part_desc : $this->web_part_name;
	}

	public function getWebFamilyAttribute() {
		return $this->details->webFamily;
	}

//	public function attributes()
//	{
//		return $this->belongsToMany(ProductAttributeValues::class, 'Part_PartAttributeValue', 'part_id', 'partattributevalue_id');
//		return $this->belongsToMany(ProductAttributeValues::class, 'Part_PartAttributeValue', 'part_id', 'partattributevalue_id');
//	}

    public function scopeVisibleToActiveUser(Builder $query, $activeWebSilo = false, $activeCountry = false, $activePlant = false) {
        if ($activeWebSilo === false) $activeWebSilo = b2b()->activeWebSilo();
        if ($activeCountry === false) $activeCountry = b2b()->activeCountry();

        if ($activeWebSilo->limit_parts) {
            $query->whereHas('webSilos', function ($query) use ($activeWebSilo) {
                return $query->where('websilo_id', '=', $activeWebSilo->id);
            });
        }

        if (!$activeWebSilo->allow_private_label) {
            $query->where('private_lbl', '0');
        }

        $query->whereHas('inventoryItems', function ($query) use ($activePlant) {
            return $query->availableInPlant($activePlant);
        })->has('customerPrices');
    }

    public function scopeWebVisible(Builder $query) {
        $webSilo = b2b()->activeWebSilo();
        $country = b2b()->activeCountry();

	    if ($webSilo->limit_parts) {
            $query->whereHas('webSilos', function ($query) use ($webSilo) {
	            return $query->where('websilo_id', '=', $webSilo->id);
            });
        }

        if (!$webSilo->allow_private_label) {
	        $query->where('private_lbl', '0');
        }

//	    if ($webSilo->id == 4) {
//	        $query->whereHas('webSilos', function ($query) {
//	            return $query->where('websilo_id', '=', '4');
//            });
//        } else {
//	        $query->where('private_lbl', '0');
//        }

//        if (b2b()->activeCountry() != 'US') {
//	        $query->isNotRX();
//        }

        $query->whereHas('inventoryItems', function ($query) use ($webSilo, $country) {
//            if ($country == 'US') $query->inPlant('PLAINVILLE');
//            $query->inPlant(array_get(b2b()->activePlant(), 'plant', 'PLAINVILLE'));

            return $query->inSilo($webSilo->id);
        })->has('customerPrices');
    }

    public function customerPrices() {
        $customerPriceList = b2b()->activePriceList();
        $siloPriceList = b2b()->activeWebSilo()->priceList;
        return $this
            ->hasMany(PriceList::class, 'part_id', 'id')
            ->whereIn('price_list', [$customerPriceList, $siloPriceList])
            ->where('currency', b2b()->activeCurrency())
            ;
    }

	public function prices() {
	    return $this->hasMany(PriceList::class, 'part_id');
	}

	public function getListPriceForCurrencyCode($currencyCode) {
	    if ($currencyCode == 'USD') return $this->list_price;

        $exchangeRate = CurrencyRate::current()->value($currencyCode);
        return ($exchangeRate) ? round($this->list_price * $exchangeRate, 2) : $this->list_price;
    }

	public function getPricesArrayAttribute() {
	    $prices = [];
        $this->customerPrices->each(function ($item) use (&$prices) {
            $prices[$item->price_list][$item->quantity_level] = collect($item->toArray())->sortByDesc('quantity_level');
        });
        if (array_has($prices, b2b()->activePriceList())) return $prices[b2b()->activePriceList()];
        return array_get($prices, b2b()->activeWebSilo()->priceList);
    }

    public function getPreDiscountCustomerPrice($quantity = 1) {
        $price = collect($this->prices_array)
            ->filter(function ($item, $key) use ($quantity) {
                return $item['quantity_level'] <= $quantity;
            })
            ->sortByDesc('quantity_level')
            ->first();
        $preDiscountPrice = array_get($price, 'price', 0);
        return $preDiscountPrice;
    }

	public function getCustomerPrice($quantity = 1) {
        $price = collect($this->prices_array)
            ->filter(function ($item, $key) use ($quantity) {
                return $item['quantity_level'] <= $quantity;
            })
            ->sortByDesc('quantity_level')
            ->first();
        $preDiscountPrice = $this->getPreDiscountCustomerPrice($quantity);

        if (array_get($price, 'contract_flag')) return $preDiscountPrice;

	    $discountAmount = round($preDiscountPrice * ($this->getCustomerDiscount() / 100), 2);
        return $preDiscountPrice - $discountAmount;
    }

    public function hasContractPrice($quantity = 1) {
        $price = collect($this->prices_array)
            ->filter(function ($item, $key) use ($quantity) {
                return $item['quantity_level'] <= $quantity;
            })
            ->sortByDesc('quantity_level')
            ->first();
        return (bool) array_get($price, 'contract_flag');
    }

    public function getDiscountPercent(Customer $customer = null) {
	    if (is_null($customer)) $customer = b2b()->activeCustomer();
	    $part = $this;

	    $customerDiscounts = $customer->discounts->filter(function ($discount) use ($part) {
	        return (
                ($discount->productfamily_id && $discount->productfamily_id == $part->productfamily_id)
                || ($discount->part_id && $discount->part_id == $part->id)
            );
        });

	    $customerDiscountAmount = 0;
	    foreach ($customerDiscounts as $customerDiscount) {
	        $customerDiscountAmount += $customerDiscount->disc_val;
        }

        $rewardsDiscountAmount = rewards()->discountForPart($this, $customer);

	    return ($rewardsDiscountAmount > $customerDiscountAmount) ? $rewardsDiscountAmount : $customerDiscountAmount;
    }

    public function getApplicableDiscounts(Customer $customer = null) {
        if (is_null($customer)) $customer = b2b()->activeCustomer();
        $part = $this;
        $discounts = [];

        $customerDiscounts = $customer->discounts->filter(function ($discount) use ($part) {
            return (
                ($discount->productfamily_id && $discount->productfamily_id == $part->productfamily_id)
                || ($discount->part_id && $discount->part_id == $part->id)
            );
        });

        $customerDiscountTotal = 0;
        foreach ($customerDiscounts as $customerDiscount) {
            $discounts[] = [
                'type' => 'customer',
                'percent' => $customerDiscount->disc_val,
            ];
            $customerDiscountTotal += $customerDiscount->disc_val;
        }
        $rewardsDiscountAmount = 0;
        if(rewards()->isEligible($customer, false)) {
            $rewardsDiscountAmount = rewards()->discountForPart($this, $customer);
        }

        if ($rewardsDiscountAmount > $customerDiscountTotal) {
            $discounts[] = [
                'type' => 'rewards',
                'percent' => $rewardsDiscountAmount,
            ];
        }

        return $discounts;
    }

    public function getCustomerDiscount(Customer $customer = null) {
	    return $this->getDiscountPercent($customer);
    }


//    public function getCustomerDiscount() {
//        $productFamilyId = $this->productfamily_id;
//        $partId = $this->id;
//        $customerDiscounts = b2b()->activeCustomer()->discounts->filter(function ($item) use ($productFamilyId, $partId) {
//            return (
//                ($item->productfamily_id && $item->productfamily_id == $productFamilyId)
//                || ($item->part_id && $item->part_id == $partId)
//            );
//        });
//
//        $customerDiscountAmount = 0;
//        foreach ($customerDiscounts as $customerDiscount) {
//            $customerDiscountAmount += $customerDiscount->disc_val;
//        }
//        $rewardsDiscountAmount = rewards()->discountForPart($this);
//
//        if ($rewardsDiscountAmount > 0 && $rewardsDiscountAmount > $customerDiscountAmount) return $rewardsDiscountAmount;
//
//        return $customerDiscountAmount;
//    }

    public function getCustomerPriceAttribute() {
        return $this->getCustomerPrice();
    }

//	public function cart_items()
//	{
//		return $this->hasMany(Cart::class, 'product_id');
//	}

	public function inventoryItems() {
        return $this->hasMany(InventoryItem::class, 'part_id', 'id');
	}

//	public function inventory_items()
//	{
//		return $this->hasMany(InventoryItem::class, 'part_id', 'id');
//	}

	public function plainvilleInventory()
	{
		return $this->hasMany(InventoryItem::class, 'part_id')->where('plant','PLAINVILLE');
	}

//	public function getImageLink($width = null, $height = null)
//	{
//		$name = ($width ? $width : 'a') . 'x' . ($height ? $height : 'a');
//		$extension_arr = array('.jpg', '.png');
//		$src =  url('img/logo_hilco.png'); //TODO: change to "NoImage" picture
//		if($this->part_no) {
//			foreach ( $extension_arr as $extension ) {
//				if(Storage::disk('product')->exists($this->part_no . $extension)){
//					if ((Image2::make(public_path('img/products/' . $this->part_no . $extension))->width() > $width || Image2::make(public_path('img/products/' . $this->part_no . $extension))->height() > $height)
//					    && (!Storage::disk('product')->exists($this->part_no . '_' . $name . $extension))) {
//						Image2::make(public_path('img/products/' . $this->part_no . $extension))->fit($width, $height)->save(public_path('img/products/' . $this->part_no . '_' . $name . $extension));
//						$src = url('img/products/'.  $this->part_no . '_' . $name . $extension);
//					} else {
//						$src = url('img/products/'.  $this->part_no . $extension);
//					}
//					break;
//				}
//			}
//		}
//
//		return $src;
//	}

	public function productFamily()	{
		return $this->belongsTo(ProductFamilies::class, 'productfamily_id', 'id');
	}

	public static function getPartsBySummary($id)
	{
		$category_arr = ProductCategory::whereHas('categoryGroup', function($categoryGroup) use ($id){
							$categoryGroup->whereHas('categorySummary', function($categorySummary) use ($id) {
								$categorySummary->where('id', '=', ($id));
							});
						})->get();
		if ($category_arr) {
			$items = array();
			foreach ($category_arr as $category) {
				$family = ProductCategory::getProductFamilies($category->id)->toArray();
				$collection = Part::where('web_part', 1)->whereIn('productfamily_id', $family)->get();
				if (!$collection->isEmpty() && $collection->count() >= 2) {
					$merge_arr = $collection->random( 2 )->toArray();
					$items = array_merge($items, $merge_arr);
				}
			}
		}
		return $items;
	}

	/**
	 * @param \Illuminate\Database\Query\Builder $query
	 * @return mixed
     */
	public function scopeDistinctProductManagers($query) {
		return $query->distinct()->select('pf_prod_mgr');
	}

	public function scopeManagedBy($query, $product_manager) {
		return $query->where('pf_prod_mgr', $product_manager);
	}

	public function scopeWebParts($query) {
		return $query->where('web_part', 1);
	}

	public static $rxProductFamilyNumbers = [
        'W01-0001',
        'W01-1500',
        'W02-0002',
        'W02-0030',
        'W02-0050',
        'W02-0053',
        'W02-0054',
        'W02-0055',
    ];

    public function getIsRXAttribute() {
        return (in_array($this->product_family_no, self::$rxProductFamilyNumbers));
    }
	
	public function scopeIsNotRX(Builder $query){
	    return $query->whereNotIn('product_family_no', self::$rxProductFamilyNumbers);
//		return $query->where(function(Builder $query){
//			return $query->where('rx_ndc','=',"")->orWhere('rx_ndc','=',"N/A");
//		})->whereHas('webPart', function (Builder $webPartQuery) {
//		    return $webPartQuery->whereHas('webFamily', function (Builder $webFamilyQuery) {
//		        return $webFamilyQuery->whereHas('webCollections', function (Builder $webCollectionsQuery) {
//		            return $webCollectionsQuery->whereHas('webCategories', function (Builder $webCategoriesQuery) {
//		                return $webCategoriesQuery->whereHas('webGroups', function (Builder $webGroupsQuery) {
//		                    return $webGroupsQuery->where('slug', '!=', 'pharmaceuticals');
//                        });
//                    });
//                });
//            });
//        });
	}

	public function inStockForPlant($plant) {
	    $inStock = false;

	    foreach ($this->inventoryItems as $inventoryItem) {
	        if ($inventoryItem->plant == $plant && $inventoryItem->in_stock) $inStock = true;
        }

        return $inStock;
    }

    public function getInStockAttribute() {
        $inStock = false;
        foreach ($this->inventoryItems as $inventoryItem) {
            if ($inventoryItem->in_stock) $inStock = true;
        }
        return $inStock;
    }

	public function getStockStatusAttribute() {
	    $stockStatus = self::UNKNOWN;
	    $activePlants = b2b()->activePlants();
	    $activeWebSilo = b2b()->activeWebSilo();
	    $activePlantNames = $activePlants->pluck('plant')->toArray();
	    if (in_array('MONTREAL', $activePlantNames) && !in_array('PLAINVILLE', $activePlantNames)) {
            $inPlainville = false;
            $inMontreal = false;

            foreach ($this->inventoryItems as $inventoryItem) {
                if ($inventoryItem->plant == 'PLAINVILLE' && $inventoryItem->in_stock) $inPlainville = true;
                if ($inventoryItem->plant == 'MONTREAL' && $inventoryItem->in_stock) $inMontreal = true;
            }

            if ($inMontreal) return self::IN_STOCK;
            else if ($inPlainville) return self::DELAYED;
            else return self::OUT_OF_STOCK;
        } else if ($activeWebSilo->id == config('hilco.hilcoOutdoorWebSiloId')) {
	        $inPlainville = false;
	        $inBozeman = false;

            foreach ($this->inventoryItems as $inventoryItem) {
                if ($inventoryItem->plant == 'PLAINVILLE' && $inventoryItem->in_stock) $inPlainville = true;
                if ($inventoryItem->plant == 'BOZEMAN' && $inventoryItem->in_stock) $$inBozeman = true;
            }

            if ($inBozeman || $inPlainville) return self::IN_STOCK;
            else return self::OUT_OF_STOCK;
        } else {
            foreach ($this->inventoryItems as $inventoryItem) {
                if (in_array($inventoryItem->plant, $activePlantNames) && $inventoryItem->in_stock) return self::IN_STOCK;
            }
            return self::OUT_OF_STOCK;
        }

        return self::UNKNOWN;
    }

    public function scopeWebSiloApproved(Builder $query, $webSiloId = false) {
	    if ($webSiloId === false) $webSiloId = b2b()->activeWebSilo()->id;
	    return $query->whereHas('webSilos', function ($webSiloQuery) use ($webSiloId) {
	        $webSiloQuery->where('require_approval', '=', '0')->where('websilo_id', '=', $webSiloId);
        });
    }

    public function getRequireApprovalAttribute() {
	    $partSilo = $this->webSilos->whereLoose('id', b2b()->activeWebSilo()->id)->first();
	    return ($partSilo && array_get($partSilo, 'pivot.require_approval', false));
    }

}

