<?php

namespace Hilco\Models;

/**
 * Class PromotionCustomerRedemption
 * @package Hilco\Models
 */
class PromotionCustomerRedemption extends UuidModel {
    protected $table = 'PromotionCustomerRedemptions';
    protected $fillable = ['promotion_id', 'customer_id', 'num_redemptions', 'commit_sequence'];

    public function promotion() {
        return $this->belongsTo(Promotion::class, 'promotion_id', 'id');
    }

    public function customer() {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function scopeByPromotionCustomer ($query, $promotion_id, $customer_id) {
        return $query->where('promotion_id', $promotion_id)->where('customer_id', $customer_id);
    }
}