<div class="panel panel-info">
    <div class="panel-body">
        <a href="{{ route('rewards.register') }}">
        <div class="row">
            @if(rewards()->tier() >= 2)
            <div class="col-sm-3 col-lg-2">
                <img src="{{ rewards()->tierImage() }}" class="img-responsive center-block" style="min-height: 80px" alt="">
            </div>
            @endif
            <div class="@if(rewards()->tier() >= 2) col-sm-9 col-lg-10 @else col-xs-12 @endif">
                <h4 class="text-center" style="margin-top: 0;">Your Hilco Vision Partnership Rewards Status</h4>
                <div class="text-right" style="color: #c0c0c0; font-weight: bold; border-right: 1px solid #c0c0c0; float: left; width: 33%">
                    Silver  <i class="fa fa-arrow-right"></i>&nbsp;
                </div>
                <div class="text-right" style="color: #daa520; font-weight: bold; border-right: 1px solid #daa520; float: left; width: 34%">
                    Gold  <i class="fa fa-arrow-right"></i>&nbsp;
                </div>
                <div class="text-right" style="color: #778899; font-weight: bold; border-right: 1px solid #778899; float: left; width: 33%">
                    Platinum <i class="fa fa-arrow-right"></i>&nbsp;
                </div>
                <div class="clearfix"></div>
                <div class="progress progress-rewards" style="margin-bottom: 1em;">
                    <div
                            data-qtip-id="details-qtip" class="rewards-progress-bar progress-bar @if(rewards()->tier() == 1) progress-bar-success @elseif(rewards()->tier() == 2) rewards-silver @elseif(rewards()->tier() == 3) rewards-gold @elseif(rewards()->tier() == 4) rewards-platinum @else progress-bar-info @endif "
                            style="width: {{ rewards()->statusPercentage() * 100 }}%"
                    >
                        <strong class="pull-right">
                            @if(rewards()->statusPercentage() * 100 < 20)
                                You&nbsp;&nbsp;
                            @else
                                Your Spending: ${{ number_format(rewards()->totalSpending(), 2) }}&nbsp;&nbsp;
                            @endif
                        </strong>
                    </div>
                    <div style="display: none;" id="details-qtip">
                        Your Spending: ${{ number_format(rewards()->totalSpending(), 2) }}&nbsp;&nbsp;
                    </div>
                    @foreach(rewards()->potential() as $cats => $pct)
                        <div data-qtip-id="potential-{{$cats}}" class="rewards-progress-bar progress-bar boost-{{ $cats }}" style="width: {{ $pct * 100 }}%">
                            + {{ $cats - rewards()->qualifyingCategories() }}
                        </div>
                        <div style="display: none;" id="potential-{{$cats}}">
                            Qualify in {{ $cats - rewards()->qualifyingCategories() }} more {{ str_plural('category', $cats - rewards()->qualifyingCategories()) }} and boost your status!
                        </div>
                    @endforeach
                </div>
                @if(rewards()->tier() < 4) <p>Increase your discount by spending more or by qualifying in more categories. Click for details!</p> @endif
            </div>
        </div>
        </a>
    </div>
</div>