<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 11/9/18
 * Time: 2:18 PM
 */

namespace Hilco\Models;

/**
 * Class PromotionCodeTrigger
 * @package Hilco\Models
 */
class PromotionCodeTrigger extends PromotionTriggerDetails {

    protected $table = 'PromotionCodeTriggers';
    protected $fillable = ['code', 'commit_sequence'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'trigger',
            'PromotionTriggers', 'trigger_id', 'promotion_id');
    }

    /**
     * Boolean, all promo trigger types need to implement to use their specific logic
     * @param Customer $soldToCustomer
     * @param $webCartItems
     * @return bool
     */
    public function isTriggered(Customer $soldToCustomer, $webCartItems = []) {
        return $this->code === session()->get('promoCode');
    }

    /**
     * promo trigger types should implement if there post operations that should happen after promo is applied
     * @param $soldToCustomer
     * @return mixed
     */
    public function postTriggerOperation(Customer $soldToCustomer) {
        // TODO: Implement postTriggerOperation() method.
    }

    /**
     * Boolean, any promo trigger that can use the Almost Qualifying Header should implement this and return 'true'
     * otherwise return 'false'
     * @return bool
     */
    public function hasAlmostQualifyingField() {
        return true;
    }

    /**
     * Any promo trigger that can use the Almost Qualifying Header should implement this and
     * @param Customer $soldToCustomer
     * @param $webCartItems
     * @return bool
     */
    public function isAlmostQualifying(Customer $soldToCustomer, $webCartItems) {
        return !$this->isTriggered($soldToCustomer, $webCartItems);
    }

    // Scopes

    public function scopeByCode($query, $promoCode) {
        return $query->where('code', $promoCode);
    }
}