<?php

namespace Hilco\Providers;
use App;
use Hilco\Models\WebAsset;
use Hilco\Models\WebPart;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\ServiceProvider;

class HilcoB2BSharedProvider extends ServiceProvider {
    public function register() {
        $this->mergeConfigFrom(__DIR__ . '/../../config/hilco.php', 'hilco');
    }

    public function boot() {
        WebPart::created(function ($webPart) {
//            $webPart->addToIndex();
        });
        WebPart::updated(function ($webPart) {
//            $webPart->addToIndex();
        });
        WebPart::deleted(function ($webPart) {
//            $webPart->getElasticSearchClient()->delete($webPart->getBasicEsParams());
        });
        
        $this->publishes([
            __DIR__ . '/../../config/layoutcomponents.php' => config_path('layoutcomponents.php')
        ], 'hilco-shared');

        $this->publishes([
            __DIR__ . '/../../config/hilco.php' => config_path('hilco.php')
        ], 'hilco');

        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'hilco');

        Relation::morphMap(WebAsset::getMorphMap());
    }
}