<?php

namespace Hilco\Models;

trait HasWebSiloOverrides {
    public function webSiloOverrides() {
        return $this
            ->morphMany(WebSiloOverride::class, 'overrideable', 'overrideable_type', 'overrideable_id')
        ;
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\MorphOne
     * @deprecated I don't think this should be used....
     */
    public function webSiloOverride() {
        return $this
            ->morphOne(WebSiloOverride::class, 'overrideable', 'overrideable_type', 'overrideable_id')
            ->where('WebSiloOverrides.websilo_id', '=', b2b()->activeWebSilo()->id)
            ->where('WebSiloOverrides.language_code', '=', b2b()->activeLanguage())
        ;
    }
}