<?php

namespace Hilco;

use Illuminate\Support\Collection;

class WebLayout {
	/**
	 * @var string
     */
	private $template;
	/**
	 * @var Collection
     */
	private $components;
	/**
	 * @var Collection
     */
	private $data;

	public function __construct($array) {
		$template = isset($array['template']) ? $array['template'] : '';
		$components = isset($array['components']) ? collect($array['components']) : new Collection;
		$data = isset($array['data']) ? collect($array['data']) : new Collection;
	}

	public function template() {
		return $this->template;
	}

	public function components() {
		return $this->components;
	}

	public function data($key) {
		return $this->data->get($key);
	}

	public function toArray() {
		return [
			'template' => $this->template,
			'components' => $this->components->toArray(),
			'data' => $this->components->toArray(),
		];
	}
}
