<?php

namespace Hilco\Models;

use Illuminate\Support\Facades\Auth;
use DB;

/**
 * Hilco\Models\WebLandingPage
 *
 * @property integer $id
 * @property integer $web_link_category_id
 * @property string $links
 * @property string $type
 * @property string $date_modified
 * @property string $deleted_at
 */
class WebLink extends WebModel {
    protected $table = "WebLinks";
    protected $fillable = ['link','type','display_name','webSiloIds'];
    public static $typeValues =['general','hilco-route'];
    public static $types =[
        'general'=>'External url or Hilco url path',
        'hilco-route' => 'Hilco Route'
    ];

    public function webSilos() {
        return $this->belongsToMany(WebSilo::class, 'WebLink_WebSilo', 'weblink_id', 'websilo_id');
    }

    public function category() {
        return $this->belongsTo(WebLinkCategory::class, 'web_link_category_id');
    }

    public function setWebSiloIdsAttribute($ids) {
        $this->save();
        $this->webSilos()->sync($ids);
    }

    public function getUrl(){
        if($this->type == self::$typeValues[0]){
            return url($this->link);
        }else if($this->type == self::$typeValues[1]){
            return route($this->link);
        }else{
            return url($this->link);
        }
    }

    public function scopeAvailableForUser($query){
        $user = Auth::user();
        $usrRoles = (isset($user))?$user->roles:null;
        return $query
            ->leftJoin('WebLink_WebSilo as WLWS', 'WLWS.weblink_id', '=', 'WebLinks.id')
            ->leftJoin('WebSilos as WS', 'WS.id', '=', 'WLWS.websilo_id')
            ->leftJoin('Role_WebSilo as RWS', 'RWS.websilo_id', '=', 'WLWS.websilo_id')
            ->select(DB::raw('WebLinks.*'))
            ->where(function($query)use($usrRoles){
                if (isset($usrRoles)){
                    return $query->whereIn('RWS.role_id',$usrRoles->pluck('id'))->where('WS.is_visible','1')->orWhereNull('RWS.role_id');
                }else{
                    return $query->whereNull('RWS.role_id');
                }
            });
    }

}
