<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 7/18/18
 * Time: 5:21 AM
 */

namespace Hilco\Models;


use Illuminate\Database\Eloquent\Model;

/**
* Hilco\Models\WebSilo_Part
*
* @property integer $id
* @property integer $websilo_id
* @property integer $part_id
* @property string $part_number
* @property string $date_created
* @property string $date_modified
* @property string $deleted_at
* @property integer $require_approval
* @property integer $minimum_quantity
* @property integer $maximum_quantity
* @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebSilo_Part whereId($value)
* @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebSilo_Part whereWebSiloId($value)
* @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebSilo_Part wherePartId($value)
* @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebSilo_Part wherePartNumber($value)
* @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebSilo_Part whereDateCreated($value)
* @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebSilo_Part whereDateModified($value)
* @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebSilo_Part whereDeletedAt($value)
* @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebSilo_Part whereRequireApproval($value)
* @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebSilo_Part whereMinimumQuantity($value)
* @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebSilo_Part whereMaximumQuantity($value)
* @mixin \Eloquent
*/
class WebSilo_Part extends Model
{

    protected $table = "WebSilo_Part";
    protected $fillable = [
        'websilo_id',
        'part_id',
        'part_number',
        'require_approval',
        'minimum_quantity',
        'maximum_quantity'
    ];

    const UPDATED_AT = 'date_modified';
    const CREATED_AT = 'date_created';

    use \Hilco\SoftDeletes;
}