<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:10 AM
 */

namespace Hilco\Events;


use Hilco\Models\WebUser;
use Illuminate\Queue\SerializesModels;

class UserWasRegistered extends Event
{
    use SerializesModels;

    /** @var WebUser */
    public $webUser;

    /**
     * True if user self-registered, false if UAC created
     * @var bool
     */
    public $selfCreated;

    public $ipAddress;

    /**
     * @var string
     */
    public $temporaryPassword;

    public $emailTemplate;

    public function __construct(WebUser $webUser, $ipAddress = false, $temporaryPassword = false, $emailTemplate, $selfCreated = true, $fromEmail = false) {
        $this->webUser = $webUser;
        $this->selfCreated = $selfCreated;
        $this->temporaryPassword = $temporaryPassword;
        $this->ipAddress = $ipAddress ? $ipAddress : request()->ip();
        $this->emailTemplate = $emailTemplate;
        $this->fromEmail = $fromEmail;
    }
}