<?php

namespace Hilco\Models;

/**
 * Class PromotionPriceListTrigger
 * @package Hilco\Models
 * @property string $pricelist_designation
 */
class PromotionPriceListTrigger extends PromotionTriggerDetails {
    protected $table = "PromotionPriceListTriggers";
    protected $fillable = ['pricelist_designation'];

    public function isTriggered (Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        $customerSegment = $soldToCustomer->customerSegment;
        return isset($customerSegment) && $customerSegment->getDefaultPriceListCode() == $this->pricelist_designation;
    }

    public function postTriggerOperation($soldToCustomer){}
}