@if($edit)
    <div class="mceNonEditable component-container" data-component-key="improvedPromoTiles">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.promo_tiles')</h4>
        <div class="row tiles-container">
            @foreach($tiles as $tileId => $tile)
                <div data-tile-id="{{ $tileId }}" data-link-type="{{ $tile['link']['type'] }}"
                     data-link-target="{{ $tile['link']['target'] }}" data-web-asset-id="{{ $tile['webAssetId'] }}"
                     @if( $tile['tileSize'] !== null) data-tile-size="{{ $tile['tileSize']}}" @else data-tile-size="12" @endif
                     class="tile-container col-xs-3">
                    <img class="improved-tile-thumbnail center-block img-responsive"
                         src="{{ webAssetUrl($tile['webAssetId']) }}">
                    @lang('hilco::app.destination_colon') <a href="#"
                                    class="improved-tile-link">{!! strlen(webLinkTitle($tile['link'])) ? webLinkTitle($tile['link']) : '<em>None</em>'  !!}</a>
                    <div class="image-size" data-img-height="@if(isset($tile['height'])){{ $tile['height'] }}@endif"
                         data-img-width="@if(isset($tile['width'])){{ $tile['width'] }}@endif">
                        @if(isset($tile['height']) && isset($tile['width']) && $tile['height'] != null && $tile['width'] != null) Height: {{ $tile['height'] }}px Width: {{ $tile['width'] }}px @endif
                    </div>
                </div>
            @endforeach
        </div>
        <h3 class="current-layout" @if($selectedLayout !== null) data-current-layout="{{ $selectedLayout }}" @else data-current-layout="full" @endif
            @if($displayName !== null) data-display-name="{{ $displayName }}" @else data-display-name="100%" @endif>
            @if($displayName !== null ) Current Layout: {{ $displayName }} @else Current Layout: 100% @endif</h3>
        <button id="changeLayout" class="btn btn-info">Change Layout</button>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('improvedPromoTiles', {
            menuText: '@lang('hilco::app.promo_tiles')',
            bladeTemplate: 'hilco::components.improvedPromoTiles',
            init: function (body) {
                var layouts = {
                    full:{
                        display_name : '100%',
                        total_tiles : 1,
                        tile_size_values :[12]
                    },
                    halves:{
                        display_name : '50% | 50%',
                        total_tiles : 2,
                        tile_size_values :[6, 6]
                    },
                    thirds: {
                        display_name : '33% | 33% | 33%',
                        total_tiles : 3,
                        tile_size_values: [4, 4, 4]
                    },
                    oneAndTwo: {
                        display_name : '33% | 66%',
                        total_tiles : 2,
                        tile_size_values: [4, 8]
                    },
                    twoAndOne: {
                        display_name : '66% | 33%',
                        total_tiles : 2,
                        tile_size_values: [8, 4]
                    },
                    quarters: {
                        display_name : '25% | 25% | 25% | 25%',
                        total_tiles : 4,
                        tile_size_values: [3, 3, 3, 3]
                    }
                };

                $(body).on('click', '.improved-tile-thumbnail', function () {
                    var tile = $(this).closest('.tile-container');
                    assets.finder({
                        successFunction: function (data) {
                            $(tile).attr('data-web-asset-id', data.id).find('img').attr('src', data.url);
                            var img = new Image();
                            img.addEventListener("load", function(){
                                console.log( this.naturalWidth +' '+ this.naturalHeight );
                                $(tile).attr('data-web-asset-id', data.id).find('.image-size').attr('data-img-height', this.naturalHeight);
                                $(tile).attr('data-web-asset-id', data.id).find('.image-size').attr('data-img-width', this.naturalWidth);
                                $(tile).attr('data-web-asset-id', data.id).find('.image-size').html("Height: "+this.naturalHeight +"px Width: "+ this.naturalWidth +"px");
                            });
                            img.src = data.url;
                        }
                    });

                });
                $(body).on('click', '.improved-tile-link', function () {
                    var tile = $(this).closest('.tile-container');
                    assets.link({
                        successFunction: function (data) {
                            $(tile).attr('data-link-type', data.link_type);
                            $(tile).attr('data-link-target', data.target);
                            $(tile).find('.improved-tile-link').text(data.description);
                        }
                    });
                }).on('click', '#changeLayout', function () {
                    var mainComponent = $(this).closest('.component-container');

                    var message = "Choose a layout for the content.";
                    var layout = $(mainComponent).find('h3.current-layout').attr('data-current-layout');

                    swal({
                        title: "Change Layout",
                        type: "info",
                        html: message,
                        input: 'select',
                        inputOptions: {
                            full: '100%',
                            halves: '50% | 50%',
                            thirds:'33% | 33% | 33%',
                            oneAndTwo: '33% | 66%',
                            twoAndOne:'66% | 33%',
                            quarters:'25% | 25% | 25% | 25%'
                        },
                        inputPlaceholder: 'Select a layout',
                        inputValue: layout,
                        confirmButtonClass: "btn-primary",
                        showCancelButton: true,
                        allowOutsideClick: false,
                    }).then(
                        function(inputValue){
                            var current_layout = layouts[layout];
                            var chosen_layout = layouts[inputValue];
                            if(current_layout != chosen_layout){

                                $(mainComponent).find('h3.current-layout').attr('data-current-layout', inputValue);
                                $(mainComponent).find('h3.current-layout').attr('data-display-name', layouts[inputValue]['display_name']);
                                $(mainComponent).find('h3.current-layout').html('Current Layout: '+ layouts[inputValue]['display_name']);

                                //change the tiles and assign the size
                                if(current_layout['total_tiles'] > chosen_layout['total_tiles']){
                                    var tilesToRemove = current_layout['total_tiles'] - chosen_layout['total_tiles'];
                                    for (let step = 0; step < tilesToRemove; step++) {
                                        var lastTile = $(mainComponent).find('div.tile-container').last();
                                        $(lastTile).remove();
                                    }
                                }else if(current_layout['total_tiles'] < chosen_layout['total_tiles']){
                                    var tilesToAdd = chosen_layout['total_tiles'] - current_layout['total_tiles'];
                                    for (let step = 0; step < tilesToAdd; step++) {
                                        var lastTile = $(mainComponent).find('div.tile-container').last();
                                        var newTileId = lastTile.data('tile-id') + 1;
                                        var newTile = lastTile.clone().attr('data-tile-id', newTileId);
                                        newTile.find('[data-tile-id]').each(function () {
                                            $(this).attr('data-tile-id', newTileId);
                                        }).find('img').attr('src', '');
                                        $(mainComponent).find('.tiles-container').append(newTile);
                                    }
                                }

                                var loops = 0;

                                $(mainComponent).find('.tile-container').each(function () {

                                    var tileSize = chosen_layout['tile_size_values'][loops];
                                    $(this).attr('data-tile-size', tileSize);
                                    loops++;
                                });
                            }
                        });
                });
            },
            serialize: function (componentNode) {
                var selectedLayout = $(componentNode).find('h3.current-layout').data('current-layout');
                var displayName = $(componentNode).find('h3.current-layout').data('display-name');

                var data = {
                    selectedLayout: selectedLayout,
                    displayName: displayName,
                    tiles: {},
                };
                $(componentNode).find('.tile-container').each(function () {
                    var tileId = $(this).data('tile-id');

                    data.tiles[tileId] = {
                        webAssetId: $(this).data('web-asset-id'),
                        tileSize: $(this).data('tile-size'),
                        height: $(this).find('.image-size').data('img-height'),
                        width: $(this).find('.image-size').data('img-width'),
                        link: {
                            type: $(this).data('link-type'),
                            target: $(this).data('link-target'),
                        },
                    };
                });
                return data;
            },
        });
    </script>
@endif

@if($view)
    <div class="row container center-block">
        @foreach ($tiles as $tile)
            <div class="col-tn-12 col-xs-8 col-xs-offset-2 @if(!isset($tile['tileSize'])) col-sm-4  @else col-sm-{{$tile['tileSize']}} @endif col-sm-offset-0">
                <a href="{{ webLinkUrl($tile['link']) }}">
                    <img class="img-responsive center-block" src="{{ webAssetUrl($tile['webAssetId']) }}" alt="">
                </a>
                <div class="visible-tn visible-xs">
                    <br>
                </div>
            </div>
        @endforeach
        <div class="clearfix" style="margin-bottom: 20px"></div>
    </div>
@endif
