<?php

namespace Hilco\Models;

/**
 * Hilco\Models\SalesRepPermissions
 *
 * @property integer $id
 * @property string $salesrep_id
 * @property string $permission
 * @property string $allowed
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermission whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermission whereSalesRepId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermission wherePermission($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermission whereAllowed($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermission whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermission whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermission whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermission whereDeletedAt($value)
 * @mixin \Eloquent
 */
class SalesRepPermission extends WebModel {
    protected $table = "SalesRepPermissions";
    protected $fillable = ['salesrep_id', 'permission', 'allowed', 'commit_sequence'];

    use HasCommitSequence;

    /**
     * @var array
     */
    protected static $permissions = [
        'Approve Orders'            => 'approveOrders',
        'Approve Web Orders'        => 'approveWebOrders',
        'Downgrade Reward Tier'     => 'downgradeRewardTier',
        'Edit Customer Comments'    => 'editCustomerComments',
        'Remove Registration'       => 'removeRegistration',
        'Upgrade Reward Tier'       => 'upgradeRewardTier',
    ];

    /**
     * @return array
     */
    public static function getPermissions() {
        return self::$permissions;
    }

    public function scopeByRepPermission($query, $repId, $permission) {
        return $query
                ->where('salesrep_id', $repId)
                ->where('permission', $permission);
    }
}