@if($edit)
    <div class="mceNonEditable component-container" data-component-key="bestSellers">
<a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.best_sellers')</h4>
        <p>@lang('hilco::app.displays_best_selling_families_that_are_children_of_this_container')</p>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('bestSellers', {
            menuText: '@lang('hilco::app.best_sellers')',
            bladeTemplate: 'hilco::components.bestSellers',
            init: function (body) {

            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    @if(isset($bestSellers) && count($bestSellers))
        <div class="row container center-block">
            <div class="col-md-12">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <h3 class="panel-title text-center">{{ b2b()->getB2BTranslation('hilco::components.bestSellers', 'b2bMainPageBestSellersTitle', 'Best Sellers') }}</h3>
                    </div>
                    <div class="panel-body" style="height: 280px">
                        <div id="best-sellers-carousel" class="owl-carousel owl-theme">
                            @foreach ($bestSellers as $family)
                                @include('partials.family-block', ['family' => $family, 'captionClass' => 'h4', 'containerStyle' => 'display: none;'])
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script type="text/javascript">
            $(document).ready(function() {
                var bestSellersCarousel = $('#best-sellers-carousel');
                bestSellersCarousel.on({
                    'initialized.owl.carousel': function() {
                        bestSellersCarousel.find('.family-block-item').show();
                    }
                }).owlCarousel({
                    autoplay: true,
                    autoplayTimeout: 3500,
                    autoplayHoverPause: true,
                    loop: true,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        320: {
                            items: 1
                        },
                        480: {
                            items: @if(auth()->user()) 2 @else 2 @endif,
                        },
                        768: {
                            items: @if(auth()->user()) 3 @else 3 @endif,
                        },
                        992: {
                            items: @if(auth()->user()) 3 @else 3 @endif,
                        },
                        1440: {
                            items: @if(auth()->user()) 4 @else 4 @endif,
                        },
                    },
                });
            });
        </script>
    @endif
@endif
