@if($edit)
    <div class="mceNonEditable component-container" data-component-key="enhancedJumbotron">
<a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.enhanced_jumbotron')</h4>
        <p>@lang('hilco::app.displays_a_large_banner_across_the_entire_width_of_the_page_with_text_overlay')</p>
        <div style="position:relative; display: inline-block">
            <img data-web-asset-id="{{ $webAssetId }}" id="jumbotronThumbnail" src="{{ webAssetUrl($webAssetId) }}" class="img-responsive center-block">
            <div class="overlay-div"
                    style="position: absolute;
                    z-index: 999;
                    margin: 0 auto;
                    @if( $textAreaLocation == "right" )left: 60%; @else left: 0; @endif
                    @if( $textAreaLocation == "left" )right: 60%; @else right: 0; @endif
                    top: 20%;
                    text-align: center;
                    width: 33%;
                    background: rgba(214, 214, 214, .9);
                    padding-bottom:8px;"
            >
                <div style="border-bottom: solid black 1px; padding-bottom:8px; margin-bottom: 3px; margin-top: 8px; width: 80%; margin-left: 10%">
                    <h6 style="display: inline-block; font-weight: bold; margin-right: 5px;">Header</h6>
                     <button @if($buttonLocation != 'header') style="display: none "@endif class="btn btn-xs btn-primary header-button">Button</button>
                </div>

                <div style="margin: 5px;">
                    <p>Body</p>
                    <button @if($buttonLocation != 'footer') style="display: none "@endif class="btn btn-xs btn-primary footer-button">Button</button>
                </div>
            </div>
        </div>

        <div>
            Header: &nbsp; <div style="display: inline;" class="header-preview"> @if($header) {{ $header }} @else None @endif</div><br>
            Body: &nbsp; <div style="display: inline;" class="body-preview"> @if($body) {{ $body }} @else None @endif</div><br>
            Button Text: &nbsp; <div style="display: inline;" class="button-preview"> @if($button) {{ $button }} @else None @endif</div><br>
            Button Link: &nbsp; <div style="display: inline;" class="link-preview"> @if($link) {{ $link }} @else None @endif</div><br>
            Button Location: &nbsp; <div style="display: inline;" class="button-location-preview"> @if($buttonLocation) {{ ucfirst($buttonLocation) }} @else None @endif</div><br>
            Overlay Location: &nbsp; <div style="display: inline;" class="overlay-preview"> @if($textAreaLocation) {{ ucfirst($textAreaLocation) }} @else None @endif</div><br>
        </div>

        <button class="btn btn-md btn-primary set-overlay" data-header-text="{{ $header }}" data-body-text="{{ $body }}" @if($button == null || $button == '') data-button-check="false" @else data-button-check="true" @endif data-button-text="{{ $button }}" data-button-link="{{ $link }}" data-textarea-location="{{ $textAreaLocation }}" data-button-location="{{ $buttonLocation }}">Edit Text Area</button>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('enhancedJumbotron', {
            menuText: '@lang('hilco::app.enhanced_jumbotron')',
            bladeTemplate: 'hilco::components.enhancedJumbotron',
            init: function (body) {
                $(body).on('click', '#jumbotronThumbnail', function() {
                    var container = $(this).closest('.component-container');
                    assets.finder({
                        successFunction: function(data) {
                            $(container).find('img#jumbotronThumbnail')
                                    .attr('src', data.url)
                                    .attr('data-web-asset-id', data.id)
                            ;
                        }
                    });
                }).on('click', '.set-overlay', function () {
                    $(document).off('click', '#text_description_submit');

                    var mainComponent = $(this).closest('.component-container');

                    var button = $(this);

                    var currentHeader = $(this).attr('data-header-text');
                    document.getElementById("text_description_header").value = currentHeader;

                    var currentButtonCheck = $(this).attr('data-button-check');
                    var check = document.getElementById("include_button");
                    if(currentButtonCheck == 'true'){
                        $(check).prop( "checked", true );
                        $("#button_options").show();
                    }else{
                        $(check).prop( "checked", false );
                        $("#button_options").hide();
                    }

                    document.getElementById("include_button").value = currentButtonCheck;
                    var currentButtonText = $(this).attr('data-button-text');
                    document.getElementById("button_text").value = currentButtonText;
                    var currentButtonLink = $(this).attr('data-button-link');
                    document.getElementById("button_link").value = currentButtonLink;

                    var currentButtonLocation = $(this).attr('data-button-location');
                    if(currentButtonLocation == 'header'){
                        $("#radio_header").prop('checked', true);
                    }else{
                        $("#radio_footer").prop('checked', true);
                    }

                    var currentBody = $(this).attr('data-body-text');
                    document.getElementById("text_description_body").value = currentBody;

                    var currentTextAreaLocation = $(this).attr('data-textarea-location');
                    if(currentTextAreaLocation == 'left'){
                        $("#radio_left").prop('checked', true);
                    }else if(currentTextAreaLocation == 'right'){
                        $("#radio_right").prop('checked', true);
                    }else{
                        $("#radio_center").prop('checked', true);
                    }

                    $("#text-description-modal").find(".overlay-options").show();
                    $("#text-description-modal").modal('show');

                    $(document).on('click', '#text_description_submit', function (e){
                        var header = document.getElementById("text_description_header").value;
                        var buttonCheck = document.getElementById("include_button").checked;
                        if(buttonCheck){
                            var buttonText = document.getElementById("button_text").value;
                            var buttonLink = document.getElementById("button_link").value;
                            var buttonLocation = $("input[name='buttonLocation']:checked").val();
                        }else{
                            var buttonText = '';
                            var buttonLink = '';
                            var buttonLocation = '';
                        }

                        var body = document.getElementById("text_description_body").value;
                        var textAreaLocation = $("input[name='textAreaLocation']:checked").val();

                        $(button).attr('data-header-text', header);
                        $(button).attr('data-button-check', buttonCheck);
                        $(button).attr('data-button-text', buttonText);
                        $(button).attr('data-button-link', buttonLink);
                        $(button).attr('data-button-location', buttonLocation);
                        $(button).attr('data-body-text', body);
                        $(button).attr('data-textarea-location', textAreaLocation);

                        $(mainComponent).find('.header-preview').html(header);
                        $(mainComponent).find('.body-preview').html(body);
                        if(textAreaLocation == 'left'){
                            $(mainComponent).find('.overlay-div').css("left" , 0);
                            $(mainComponent).find('.overlay-div').css("right" , '60%');
                            $(mainComponent).find('.overlay-preview').html("Left");
                        }else if(textAreaLocation == 'right'){
                            $(mainComponent).find('.overlay-div').css("left" , '60%');
                            $(mainComponent).find('.overlay-div').css("right" , 0);
                            $(mainComponent).find('.overlay-preview').html("Right");
                        }else{
                            $(mainComponent).find('.overlay-div').css("left" , 0);
                            $(mainComponent).find('.overlay-div').css("right" , 0);
                            $(mainComponent).find('.overlay-preview').html("Center");
                        }

                        if(buttonText == ''){
                            $(mainComponent).find('.button-preview').html('None');
                            $(mainComponent).find('.link-preview').html('None');
                            $(mainComponent).find('.button-location-preview').html('None');
                            $(mainComponent).find('.header-button').hide();
                            $(mainComponent).find('.footer-button').hide();

                        }else{
                            $(mainComponent).find('.button-preview').html(buttonText);
                            $(mainComponent).find('.link-preview').html(buttonLink);
                            if(buttonLocation == 'header'){
                                $(mainComponent).find('.button-location-preview').html('Header');
                                $(mainComponent).find('.footer-button').hide();
                                $(mainComponent).find('.header-button').show();
                            }else{
                                $(mainComponent).find('.button-location-preview').html('Footer');
                                $(mainComponent).find('.footer-button').show();
                                $(mainComponent).find('.header-button').hide();
                            }
                        }
                        $("#text-description-modal").modal('hide');
                    });
                });
            },
            serialize: function (componentNode) {
                var button = $(componentNode).find('button.set-overlay');

                var header = $(button).data('header-text');
                var body = $(button).data('body-text');
                var buttonText = $(button).data('button-text');
                var buttonLink = $(button).data('button-link');
                var textAreaLocation = $(button).data('textarea-location');
                var buttonLocation = $(button).data('button-location');

                var data = {
                    webAssetId: $(componentNode).find('img#jumbotronThumbnail').data('web-asset-id'),
                    full: true,
                    header: header,
                    body: body,
                    button: buttonText,
                    link: buttonLink,
                    textAreaLocation: textAreaLocation,
                    buttonLocation: buttonLocation
                };

                return data;
            },
        });
    </script>
@endif

@if($view)
    <div class="row">
        <div class="col-sm-12 hidden-xs" style="position:relative; display: inline-block">
            <img style="width: 100%;" class="img-responsive" src="{{webAssetUrl($webAssetId)}}" alt="">
            <div
                    style="position: absolute;
                            z-index: 999;
                            margin: 0 auto;
                    @if( isset($textAreaLocation) && $textAreaLocation == "right" )left: 60%; @else left: 0; @endif
                    @if( isset($textAreaLocation) && $textAreaLocation == "left" )right: 60%; @else right: 0; @endif
                            top: 20%;
                            text-align: center;
                            width: 33%;
                            background: rgba(214, 214, 214, .9);
                            padding-bottom:8px;"
            >
                <div style="border-bottom: solid black 1px; padding-bottom:8px; margin-bottom: 3px; margin-top: 8px; width: 80%; margin-left: 10%">
                    <h3 style="display: inline-block; font-weight: bold; margin-right: 10px;">{{ $header }}</h3>
                    @if(($button != null && $button != "") && ($buttonLocation != null && $buttonLocation == 'header')) <button class="btn btn-md btn-primary" href="{!! $link !!}">{{ $button }}</button>@endif
                </div>

                <div style="margin: 5px;">
                    <p>{{ $body }}</p>
                    @if(($button != null && $button != "") && ($buttonLocation != null && $buttonLocation == 'footer')) <button class="btn btn-md btn-primary" href="{!! $link !!}">{{ $button }}</button>@endif
                </div>
            </div>
        </div>
        <div class="hidden-sm hidden-md hidden-lg col-xs-12">
            <img style="width: 100%;" class="img-responsive" src="{{webAssetUrl($webAssetId)}}" alt="">
            <div>
                <div style="border-bottom: solid black 1px; padding-bottom:8px; margin-bottom: 3px; margin-top: 8px; width: 80%; margin-left: 10%">
                    <h3 style="display: inline-block; font-weight: bold; margin-right: 10px;">{{ $header }}</h3>
                    @if(($button != null && $button != "") && ($buttonLocation != null && $buttonLocation == 'header')) <button class="btn btn-sm btn-primary" href="{!! $link !!}">{{ $button }}</button>@endif
                </div>
                <div style="margin: 5px;">
                    <p>{{ $body }}</p>
                    @if(($button != null && $button != "") && ($buttonLocation != null && $buttonLocation == 'footer')) <button class="btn btn-sm btn-primary" href="{!! $link !!}">{{ $button }}</button>@endif
                </div>
            </div>
        </div>
    </div>
    <br>
@endif
