<?php

namespace Hilco\Models;

/**
 * Hilco\Models\FeedbackType
 *
 * @property mixed $id
 * @property string $feedback_type_text
 * @property string $feedback_type_displayOrder
 * @property string $deleted_at
 * @property string $date_created
 * @property string $date_modified
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackType whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackType whereFeedbackTypeText($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackType whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackType whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FeedbackType whereDeletedAt($value)
 * @mixin \Eloquent
 */
class FeedbackType extends WebModel
{
    protected $table = 'FeedbackTypes';

    public function feedbackSubjects()
    {
        return $this->hasMany(FeedbackSubject::class, 'feedback_type_id');
    }

    public function webFeedbackResponses()
    {
        return $this->hasMany(WebFeedbackResponse::class, 'feedback_type_id');
    }

    public function getFeedbackTypeTextAttribute() {
        $lang = b2b()->activeLanguage();
        $webTranslation = WebTranslation::where('translatable_id', '=', $this->id)
                                        ->where('translatable_type', '=', 'feedBackType')
                                        ->where('language', '=', $lang)
                                        ->where('key', '=', 'name')
                                        ->where('deleted_at', '=', '0000-00-00 00:00:00')
                                        ->first();
        return $webTranslation->value;
//        $translatedName = $this->getTranslation('name');
//        if (!strlen($translatedName)) $translatedName = $this->attributes['feedback_type_text'];
//        return $translatedName;
    }

    public function getDisplayNameForUACAttribute() {
        return $this->getFeedbackTypeTextAttribute();
    }

    use HasModelTranslations;
}
