<?php

namespace Hilco\Providers;
use App;
use Hilco\Events\UserWasRegistered;
use Hilco\Listeners\EmailNewUserAlert;
use Hilco\Models\Customer;
use Hilco\Models\ProductCategoryGroup;
use Hilco\Models\Promotion;
use Hilco\Models\PromotionCurrentOrderTrigger;
use Hilco\Models\PromotionCustomerTrigger;
use Hilco\Models\PromotionItemDiscountAction;
use Hilco\Models\WebAsset;
use Hilco\Models\WebPart;
use Hilco\Shipments\ShipmentManager;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Validator;
use Illuminate\View\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;

class HilcoB2BSharedProvider extends ServiceProvider {
    public function register() {
        $this->mergeConfigFrom(__DIR__ . '/../../config/hilco.php', 'hilco');
        $this->mergeConfigFrom(__DIR__ . '/../../config/rewards.php', 'rewards');
        $this->mergeConfigFrom(__DIR__ . '/../../config/creditcards.php', 'creditcards');
        $this->mergeConfigFrom(__DIR__ . '/../../config/croakiesadventures.php', 'croakiesadventures');

        App::singleton('rateShop', function() {
            return new \Hilco\RateShop();
        });

        App::singleton('rewards', function () {
            return new \Hilco\RewardsHelper();
        });

        $this->app->singleton('b2b', function () {
            return new \Hilco\B2BHelper();
        });

        App::singleton('m3', function () {
            return new \Hilco\M3Helper();
        });

        $this->app->bind('shipmentManager', function () {
            return new ShipmentManager();
        });

        $this->app->singleton('croakies', function(){
            return new \Hilco\CroakiesHelper();
        });
    }

    public function boot() {
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'hilco');

        $this->publishes([
            __DIR__ . '/../../config/layoutcomponents.php' => config_path('layoutcomponents.php')
        ], 'hilco-shared');

        $this->publishes([
            __DIR__ . '/../../config/hilco.php' => config_path('hilco.php')
        ], 'hilco');

        $this->publishes([
            __DIR__ . '/../../config/rewards.php' => config_path('rewards.php')
        ], 'rewards');

        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'hilco');

        Relation::morphMap(WebAsset::getMorphMap());
        Relation::morphMap(Promotion::getMorphMap());
        Relation::morphMap([
            'customer' => Customer::class,
            'productCategoryGroup' => ProductCategoryGroup::class,
            'jpeInvoice' => JPEInvoice::class,
        ]);

        view()->creator('hilco::components.*', function (View $view) {
            $data = $view->getData();
            if (!array_has($data, 'edit')) $view->with('edit', false);
            if (!array_has($data, 'wrap')) $view->with('wrap', false);
            if (!array_has($data, 'script')) $view->with('script', false);
            if (!array_has($data, 'view')) $view->with('view', false);
        });

        foreach (config('hilco.components', []) as $key => $component) {
            view()->creator($component['view'], function (View $view) use ($component) {
                $viewData = $view->getData();
                $compData = array_dot($component['defaultViewData']);
                foreach ($compData as $kk => $vv) {
                    if (!array_has($viewData, $kk)) array_set($viewData, $kk, $vv);
                }
                $view->with($viewData);
            });
        }

        Blade::directive('pushonce', function ($expression) {
            $array = explode(':', trim(substr($expression, 2, -2)));
            $pushType = $array[0];
            $pushId = $array[1];
            $isDisplayed = "__pushonce__{$pushType}__{$pushId}";
            return "<?php if (!isset(\$__env->{$isDisplayed})): \$__env->{$isDisplayed} = true; \$__env->startPush('{$pushType}'); ?>";
        });

        Blade::directive('endpushonce', function ($expression) {
            return '<?php $__env->stopPush(); endif; ?>';
        });
    }
}